/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.resamp;

import org.esa.snap.core.dataop.resamp.Resampling;

final class CubicConvolutionResampling
implements Resampling {
    CubicConvolutionResampling() {
    }

    @Override
    public String getName() {
        return "CUBIC_CONVOLUTION";
    }

    @Override
    public final Resampling.Index createIndex() {
        return new Resampling.Index(4, 1);
    }

    @Override
    public final void computeIndex(double x, double y, int width, int height, Resampling.Index index) {
        index.x = x;
        index.y = y;
        index.width = width;
        index.height = height;
        int i0 = (int)Math.floor(x);
        int j0 = (int)Math.floor(y);
        index.i0 = i0;
        index.j0 = j0;
        double di = x - ((double)i0 + 0.5);
        double dj = y - ((double)j0 + 0.5);
        int iMax = width - 1;
        if (di >= 0.0) {
            index.i[0] = Resampling.Index.crop(i0 - 1, iMax);
            index.i[1] = Resampling.Index.crop(i0, iMax);
            index.i[2] = Resampling.Index.crop(i0 + 1, iMax);
            index.i[3] = Resampling.Index.crop(i0 + 2, iMax);
            index.ki[0] = di;
        } else {
            index.i[0] = Resampling.Index.crop(i0 - 2, iMax);
            index.i[1] = Resampling.Index.crop(i0 - 1, iMax);
            index.i[2] = Resampling.Index.crop(i0, iMax);
            index.i[3] = Resampling.Index.crop(i0 + 1, iMax);
            index.ki[0] = di + 1.0;
        }
        int jMax = height - 1;
        if (dj >= 0.0) {
            index.j[0] = Resampling.Index.crop(j0 - 1, jMax);
            index.j[1] = Resampling.Index.crop(j0, jMax);
            index.j[2] = Resampling.Index.crop(j0 + 1, jMax);
            index.j[3] = Resampling.Index.crop(j0 + 2, jMax);
            index.kj[0] = dj;
        } else {
            index.j[0] = Resampling.Index.crop(j0 - 2, jMax);
            index.j[1] = Resampling.Index.crop(j0 - 1, jMax);
            index.j[2] = Resampling.Index.crop(j0, jMax);
            index.j[3] = Resampling.Index.crop(j0 + 1, jMax);
            index.kj[0] = dj + 1.0;
        }
    }

    @Override
    public final double resample(Resampling.Raster raster, Resampling.Index index) throws Exception {
        int[] x = new int[4];
        int[] y = new int[4];
        double[][] samples = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            x[i] = (int)index.i[i];
            y[i] = (int)index.j[i];
        }
        if (!raster.getSamples(x, y, samples)) {
            int j;
            int i;
            if (Double.isNaN(samples[1][1])) {
                return samples[1][1];
            }
            double mean = 0.0;
            int k = 0;
            for (i = 0; i < 4; ++i) {
                for (j = 0; j < 4; ++j) {
                    if (Double.isNaN(samples[i][j])) continue;
                    mean += samples[i][j];
                    ++k;
                }
            }
            mean /= (double)k;
            for (i = 0; i < 4; ++i) {
                for (j = 0; j < 4; ++j) {
                    if (!Double.isNaN(samples[i][j])) continue;
                    samples[i][j] = mean;
                }
            }
        }
        double muX = index.ki[0];
        double muY = index.kj[0];
        double muX2 = muX * muX;
        double muX3 = muX2 * muX;
        double c0 = 0.5 * (-muX + 2.0 * muX2 - muX3);
        double c1 = 0.5 * (2.0 - 5.0 * muX2 + 3.0 * muX3);
        double c2 = 0.5 * (muX + 4.0 * muX2 - 3.0 * muX3);
        double c3 = 0.5 * (-muX2 + muX3);
        double sum = c0 + c1 + c2 + c3;
        double tmpV0 = (c0 * samples[0][0] + c1 * samples[0][1] + c2 * samples[0][2] + c3 * samples[0][3]) / sum;
        double tmpV1 = (c0 * samples[1][0] + c1 * samples[1][1] + c2 * samples[1][2] + c3 * samples[1][3]) / sum;
        double tmpV2 = (c0 * samples[2][0] + c1 * samples[2][1] + c2 * samples[2][2] + c3 * samples[2][3]) / sum;
        double tmpV3 = (c0 * samples[3][0] + c1 * samples[3][1] + c2 * samples[3][2] + c3 * samples[3][3]) / sum;
        return CubicConvolutionResampling.interpolationCubic(tmpV0, tmpV1, tmpV2, tmpV3, muY, muY * muY, muY * muY * muY);
    }

    private static double interpolationCubic(double y0, double y1, double y2, double y3, double t, double t2, double t3) {
        double c0 = 0.5 * (-t + 2.0 * t2 - t3);
        double c1 = 0.5 * (2.0 - 5.0 * t2 + 3.0 * t3);
        double c2 = 0.5 * (t + 4.0 * t2 - 3.0 * t3);
        double c3 = 0.5 * (-t2 + t3);
        double sum = c0 + c1 + c2 + c3;
        return (c0 * y0 + c1 * y1 + c2 * y2 + c3 * y3) / sum;
    }

    public String toString() {
        return "Cubic convolution resampling";
    }
}

