/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.image.AbstractMosaicSubsetMultiLevelSource;
import org.esa.snap.core.image.MosaicMatrix;
import org.esa.snap.core.util.ImageUtils;

public abstract class AbstractMatrixMosaicSubsetMultiLevelSource
extends AbstractMosaicSubsetMultiLevelSource {
    protected final MosaicMatrix mosaicMatrix;

    protected AbstractMatrixMosaicSubsetMultiLevelSource(MosaicMatrix mosaicMatrix, Rectangle imageMatrixReadBounds, Dimension tileSize, GeoCoding geoCoding) {
        this(mosaicMatrix, imageMatrixReadBounds, tileSize, Product.findImageToModelTransform(geoCoding));
    }

    protected AbstractMatrixMosaicSubsetMultiLevelSource(MosaicMatrix mosaicMatrix, Rectangle imageMatrixReadBounds, Dimension tileSize, AffineTransform imageToModelTransform) {
        super(imageMatrixReadBounds, tileSize, imageToModelTransform);
        if (mosaicMatrix == null) {
            throw new NullPointerException("The mosaic matrix is null.");
        }
        if (!mosaicMatrix.isConsistent()) {
            throw new IllegalArgumentException("The matrix has empty cells.");
        }
        this.mosaicMatrix = mosaicMatrix;
    }

    protected AbstractMatrixMosaicSubsetMultiLevelSource(int levelCount, MosaicMatrix mosaicMatrix, Rectangle imageMatrixReadBounds, Dimension tileSize, AffineTransform imageToModelTransform) {
        super(levelCount, imageMatrixReadBounds, tileSize, imageToModelTransform);
        if (mosaicMatrix == null) {
            throw new NullPointerException("The mosaic matrix is null.");
        }
        if (!mosaicMatrix.isConsistent()) {
            throw new IllegalArgumentException("The matrix has empty cells.");
        }
        this.mosaicMatrix = mosaicMatrix;
    }

    protected abstract List<RenderedImage> buildMatrixCellTileImages(int var1, Rectangle var2, float var3, float var4, MosaicMatrix.MatrixCell var5);

    protected final RenderedImage createImage(int level) {
        int levelTotalImageWidth = this.computeLevelTotalImageWidth(level);
        int levelTotalImageHeight = this.computeLevelTotalImageHeight(level);
        int lastRowIndex = this.mosaicMatrix.getRowCount() - 1;
        int lastColumnIndex = this.mosaicMatrix.getColumnCount() - 1;
        ArrayList<RenderedImage> matrixTileImages = new ArrayList<RenderedImage>();
        int cellMatrixOffsetY = 0;
        for (int rowIndex = 0; rowIndex <= lastRowIndex; ++rowIndex) {
            int cellMatrixOffsetX = 0;
            for (int columnIndex = 0; columnIndex <= lastColumnIndex; ++columnIndex) {
                MosaicMatrix.MatrixCell matrixCell = this.mosaicMatrix.getCellAt(rowIndex, columnIndex);
                Rectangle cellMatrixBounds = new Rectangle(cellMatrixOffsetX, cellMatrixOffsetY, matrixCell.getCellWidth(), matrixCell.getCellHeight());
                Rectangle intersectionMatrixBounds = this.imageReadBounds.intersection(cellMatrixBounds);
                if (!intersectionMatrixBounds.isEmpty()) {
                    int cellLocalOffsetX = intersectionMatrixBounds.x - cellMatrixBounds.x;
                    int cellLocalOffsetY = intersectionMatrixBounds.y - cellMatrixBounds.y;
                    Rectangle cellLocalIntersectionBounds = new Rectangle(cellLocalOffsetX, cellLocalOffsetY, intersectionMatrixBounds.width, intersectionMatrixBounds.height);
                    int levelCellImageWidth = ImageUtils.computeLevelSize(cellLocalIntersectionBounds.width, level);
                    int levelCellImageHeight = ImageUtils.computeLevelSize(cellLocalIntersectionBounds.height, level);
                    float cellTranslateLevelOffsetX = (float)ImageUtils.computeLevelSizeAsDouble(intersectionMatrixBounds.x - this.imageReadBounds.x, level);
                    cellTranslateLevelOffsetX -= AbstractMatrixMosaicSubsetMultiLevelSource.computeTranslateDifference(cellTranslateLevelOffsetX, levelCellImageWidth, levelTotalImageWidth, columnIndex, lastColumnIndex, level);
                    float cellTranslateLevelOffsetY = (float)ImageUtils.computeLevelSizeAsDouble(intersectionMatrixBounds.y - this.imageReadBounds.y, level);
                    cellTranslateLevelOffsetY -= AbstractMatrixMosaicSubsetMultiLevelSource.computeTranslateDifference(cellTranslateLevelOffsetY, levelCellImageHeight, levelTotalImageHeight, rowIndex, lastRowIndex, level);
                    List<RenderedImage> cellTileImages = this.buildMatrixCellTileImages(level, cellLocalIntersectionBounds, cellTranslateLevelOffsetX, cellTranslateLevelOffsetY, matrixCell);
                    matrixTileImages.addAll(cellTileImages);
                }
                cellMatrixOffsetX += matrixCell.getCellWidth();
            }
            cellMatrixOffsetY += this.mosaicMatrix.getCellAt(rowIndex, 0).getCellHeight();
        }
        if (matrixTileImages.size() > 0) {
            return this.buildMosaicOp(level, matrixTileImages, false);
        }
        return null;
    }

    protected final MatrixReadBounds computeTopLeftMatrixCellReadBounds() {
        int lastRowIndex = this.mosaicMatrix.getRowCount() - 1;
        int lastColumnIndex = this.mosaicMatrix.getColumnCount() - 1;
        int cellMatrixOffsetY = 0;
        for (int rowIndex = 0; rowIndex <= lastRowIndex; ++rowIndex) {
            int cellMatrixOffsetX = 0;
            for (int columnIndex = 0; columnIndex <= lastColumnIndex; ++columnIndex) {
                MosaicMatrix.MatrixCell matrixCell = this.mosaicMatrix.getCellAt(rowIndex, columnIndex);
                Rectangle cellMatrixBounds = new Rectangle(cellMatrixOffsetX, cellMatrixOffsetY, matrixCell.getCellWidth(), matrixCell.getCellHeight());
                Rectangle intersectionMatrixBounds = this.imageReadBounds.intersection(cellMatrixBounds);
                if (!intersectionMatrixBounds.isEmpty()) {
                    int cellLocalOffsetX = intersectionMatrixBounds.x - cellMatrixBounds.x;
                    int cellLocalOffsetY = intersectionMatrixBounds.y - cellMatrixBounds.y;
                    Rectangle cellLocalIntersectionBounds = new Rectangle(cellLocalOffsetX, cellLocalOffsetY, intersectionMatrixBounds.width, intersectionMatrixBounds.height);
                    return new MatrixReadBounds(cellLocalIntersectionBounds, matrixCell);
                }
                cellMatrixOffsetX += matrixCell.getCellWidth();
            }
            cellMatrixOffsetY += this.mosaicMatrix.getCellAt(rowIndex, 0).getCellHeight();
        }
        return null;
    }

    protected static class MatrixReadBounds {
        private final Rectangle cellLocalIntersectionBounds;
        private final MosaicMatrix.MatrixCell matrixCell;

        MatrixReadBounds(Rectangle cellLocalIntersectionBounds, MosaicMatrix.MatrixCell matrixCell) {
            this.cellLocalIntersectionBounds = cellLocalIntersectionBounds;
            this.matrixCell = matrixCell;
        }

        public Rectangle getCellLocalIntersectionBounds() {
            return this.cellLocalIntersectionBounds;
        }

        public MosaicMatrix.MatrixCell getMatrixCell() {
            return this.matrixCell;
        }
    }
}

