/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.image.LevelImageSupport;
import org.esa.snap.core.image.RasterDataNodeOpImage;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.runtime.Config;

public class BandOpImage
extends RasterDataNodeOpImage {
    public static boolean prefetchTiles;

    public BandOpImage(Band band) {
        this(band, ResolutionLevel.MAXRES);
    }

    public BandOpImage(Band band, ResolutionLevel level) {
        super(band, level);
        if (Boolean.getBoolean("snap.imageManager.disableSourceTileCaching")) {
            this.setTileCache(null);
        }
        prefetchTiles = Config.instance((String)"snap").preferences().getBoolean("snap.jai.prefetchTiles", true);
    }

    public Band getBand() {
        return (Band)this.getRasterDataNode();
    }

    @Override
    protected void computeProductData(ProductData destData, Rectangle destRect) throws IOException {
        Band band = this.getBand();
        if (band.getProductReader() == null) {
            throw new IllegalStateException("no product reader for band '" + band.getDisplayName() + "'");
        }
        if (this.getLevel() == 0) {
            band.getProductReader().readBandRasterData(band, destRect.x, destRect.y, destRect.width, destRect.height, destData, ProgressMonitor.NULL);
        } else {
            BandOpImage.readHigherLevelData(band, destData, destRect, this.getLevelImageSupport());
        }
    }

    private static void readHigherLevelData(Band band, ProductData destData, Rectangle destRect, LevelImageSupport lvlSupport) throws IOException {
        AbstractProductReader reader;
        if (band.isProductReaderDirectlyUsable() && band.getProductReader() instanceof AbstractProductReader && (reader = (AbstractProductReader)band.getProductReader()).isSubsetReadingFullySupported()) {
            ProductIO.readLevelBandRasterData(reader, band, lvlSupport, destRect, destData);
            return;
        }
        int sourceWidth = lvlSupport.getSourceWidth(destRect.width);
        int sourceHeight = lvlSupport.getSourceHeight(destRect.height);
        int srcX = lvlSupport.getSourceX(destRect.x);
        int srcY = lvlSupport.getSourceY(destRect.y);
        MultiLevelImage img = band.getSourceImage();
        int tileWidth = img.getTileWidth();
        int tileHeight = img.getTileHeight();
        Map<Integer, List<PositionCouple>> xSrcTiled = BandOpImage.computeTiledL0AxisIdx(destRect.x, destRect.width, tileWidth, lvlSupport::getSourceX);
        Map<Integer, List<PositionCouple>> ySrcTiled = BandOpImage.computeTiledL0AxisIdx(destRect.y, destRect.height, tileHeight, lvlSupport::getSourceY);
        Point[] tileIndices = img.getTileIndices(new Rectangle(srcX, srcY, sourceWidth, sourceHeight));
        if (prefetchTiles) {
            img.prefetchTiles(tileIndices);
        }
        for (Point tileIndex : tileIndices) {
            Rectangle tileRect;
            int xTileIdx = tileIndex.x;
            int yTileIdx = tileIndex.y;
            List<PositionCouple> yPositions = ySrcTiled.get(yTileIdx);
            List<PositionCouple> xPositions = xSrcTiled.get(xTileIdx);
            if (yPositions == null || xPositions == null || (tileRect = img.getTileRect(xTileIdx, yTileIdx)).isEmpty()) continue;
            ProductData tileData = ProductData.createInstance(band.getDataType(), tileRect.width * tileRect.height);
            band.readRasterData(tileRect.x, tileRect.y, tileRect.width, tileRect.height, tileData, ProgressMonitor.NULL);
            for (PositionCouple yPos : yPositions) {
                int ySrc = yPos.srcPos;
                int yPosInTile = ySrc % tileHeight;
                int yOffsetInTile = yPosInTile * tileRect.width;
                int yDest = yPos.destPos;
                int yDestOffset = (yDest - destRect.y) * destRect.width;
                for (PositionCouple xPos : xPositions) {
                    int xSrc = xPos.srcPos;
                    int xPosInTile = xSrc % tileWidth;
                    int xDest = xPos.destPos;
                    double v = tileData.getElemDoubleAt(yOffsetInTile + xPosInTile);
                    destData.setElemDoubleAt(yDestOffset + xDest - destRect.x, v);
                }
            }
        }
    }

    static Map<Integer, List<PositionCouple>> computeTiledL0AxisIdx(int destStart, int destAxislength, int tileAxisLengthL0, SourceConverter lvlSupport) {
        HashMap<Integer, List<PositionCouple>> map = new HashMap<Integer, List<PositionCouple>>();
        for (int i = destStart; i < destStart + destAxislength; ++i) {
            List<PositionCouple> xSrc;
            int srcIdx = lvlSupport.getSource(i);
            int tileIdx = srcIdx / tileAxisLengthL0;
            if (map.containsKey(tileIdx)) {
                xSrc = (List)map.get(tileIdx);
            } else {
                xSrc = new ArrayList();
                map.put(tileIdx, xSrc);
            }
            xSrc.add(new PositionCouple(srcIdx, i));
        }
        return map;
    }

    static class PositionCouple {
        public final int srcPos;
        public final int destPos;

        PositionCouple(int srcPos, int destPos) {
            this.srcPos = srcPos;
            this.destPos = destPos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PositionCouple that = (PositionCouple)o;
            return this.srcPos == that.srcPos && this.destPos == that.destPos;
        }

        public int hashCode() {
            return Objects.hash(this.srcPos, this.destPos);
        }

        public String toString() {
            return "PositionCouple{srcPos=" + this.srcPos + ", destPos=" + this.destPos + '}';
        }
    }

    static interface SourceConverter {
        public int getSource(int var1);
    }
}

