/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import com.bc.ceres.core.Assert;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.jexp.ParseException;

public class ColoredMaskImageMultiLevelSource
extends AbstractMultiLevelSource {
    private final Product product;
    private final Color color;
    private final String expression;
    private final boolean inverseMask;

    public static MultiLevelSource create(Product product, Color color, String expression, boolean inverseMask, AffineTransform i2mTransform) {
        Assert.notNull((Object)((Object)product));
        Assert.notNull((Object)color);
        Assert.notNull((Object)expression);
        MultiLevelModel model = null;
        try {
            RasterDataNode[] refRasters = BandArithmetic.getRefRasters(expression, product);
            if (refRasters.length > 0) {
                model = refRasters[0].getMultiLevelModel();
            }
        }
        catch (ParseException refRasters) {
            // empty catch block
        }
        if (model == null) {
            int width = product.getSceneRasterWidth();
            int height = product.getSceneRasterHeight();
            model = new DefaultMultiLevelModel(i2mTransform, width, height);
        }
        return new ColoredMaskImageMultiLevelSource(model, product, color, expression, inverseMask);
    }

    public ColoredMaskImageMultiLevelSource(MultiLevelModel model, Product product, Color color, String expression, boolean inverseMask) {
        super(model);
        this.product = product;
        this.color = color;
        this.expression = expression;
        this.inverseMask = inverseMask;
    }

    public RenderedImage createImage(int level) {
        return ImageManager.getInstance().createColoredMaskImage(this.product, this.expression, this.color, this.inverseMask, level);
    }
}

