/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import com.bc.ceres.glevel.support.DefaultMultiLevelModel;

public class MosaicMatrix {
    private final int rowCount;
    private final int columnCount;
    private final MatrixCell[][] internal;

    public MosaicMatrix(int rowCount, int columnCount) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.internal = new MatrixCell[rowCount][columnCount];
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void addCell(MatrixCell matrixCell) {
        if (matrixCell == null) {
            throw new NullPointerException("The matrix cell is null.");
        }
        int rowIndex = -1;
        int columnIndex = -1;
        boolean canContinue = true;
        for (int row = 0; row < this.rowCount && canContinue; ++row) {
            for (int column = 0; column < this.columnCount && canContinue; ++column) {
                if (this.internal[row][column] != null) continue;
                rowIndex = row;
                columnIndex = column;
                canContinue = false;
            }
        }
        if (rowIndex == -1 || columnIndex == -1) {
            throw new IllegalArgumentException("Cannot add cell past to the matrix size.");
        }
        this.setCellAt(rowIndex, columnIndex, matrixCell, false, false);
    }

    public MatrixCell getCellAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex > this.rowCount - 1) {
            throw new IllegalArgumentException("Invalid row index");
        }
        if (columnIndex < 0 || columnIndex > this.columnCount - 1) {
            throw new IllegalArgumentException("Invalid column index");
        }
        return this.internal[rowIndex][columnIndex];
    }

    public int computeTotalWidth() {
        if (!this.isConsistent()) {
            throw new UnsupportedOperationException("Current matrix has unassigned cells!");
        }
        int totalWidth = 0;
        for (int rowIndex = 0; rowIndex < this.rowCount; ++rowIndex) {
            int rowTotalWidth = 0;
            for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                rowTotalWidth += this.internal[rowIndex][columnIndex].getCellWidth();
            }
            if (totalWidth >= rowTotalWidth) continue;
            totalWidth = rowTotalWidth;
        }
        return totalWidth;
    }

    public int computeMinimumLevelCount() {
        Integer minimumLevelCount = null;
        for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
            for (int rowIndex = 0; rowIndex < this.rowCount; ++rowIndex) {
                MatrixCell cell = this.getCellAt(rowIndex, columnIndex);
                if (cell == null) {
                    throw new UnsupportedOperationException("Current matrix has unassigned cells!");
                }
                int cellLevelCount = DefaultMultiLevelModel.getLevelCount((int)cell.getCellWidth(), (int)cell.getCellHeight());
                if (minimumLevelCount != null && minimumLevelCount <= cellLevelCount) continue;
                minimumLevelCount = cellLevelCount;
            }
        }
        if (minimumLevelCount == null) {
            throw new NullPointerException("The minimum level count is null.");
        }
        return minimumLevelCount;
    }

    public int computeTotalHeight() {
        if (!this.isConsistent()) {
            throw new UnsupportedOperationException("Current matrix has unassigned cells!");
        }
        int totalHeight = 0;
        for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
            int columnTotalHeight = 0;
            for (int rowIndex = 0; rowIndex < this.rowCount; ++rowIndex) {
                columnTotalHeight += this.internal[rowIndex][columnIndex].getCellHeight();
            }
            if (totalHeight >= columnTotalHeight) continue;
            totalHeight = columnTotalHeight;
        }
        return totalHeight;
    }

    public boolean isConsistent() {
        for (int rowIndex = 0; rowIndex < this.rowCount; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                if (this.internal[rowIndex][columnIndex] != null) continue;
                return false;
            }
        }
        return true;
    }

    public void setCellAt(int rowIndex, int columnIndex, MatrixCell matrixCell, boolean doNotValidateLastColumnWidth, boolean doNotValidateLastRowHeight) {
        MatrixCell cell;
        boolean canThrowException;
        if (rowIndex < 0 || rowIndex > this.rowCount - 1) {
            throw new IllegalArgumentException("Invalid row index " + rowIndex + ". The row count is " + this.rowCount + ".");
        }
        if (columnIndex < 0 || columnIndex > this.columnCount - 1) {
            throw new IllegalArgumentException("Invalid column index " + columnIndex + ". The column count is " + this.columnCount + ".");
        }
        if (rowIndex > 0) {
            MatrixCell previousTopRowCell = this.internal[rowIndex - 1][columnIndex];
            if (matrixCell.getCellWidth() != previousTopRowCell.getCellWidth()) {
                canThrowException = true;
                if (columnIndex == this.columnCount - 1 && doNotValidateLastColumnWidth) {
                    canThrowException = false;
                }
                if (canThrowException) {
                    throw new IllegalArgumentException("Cell width " + matrixCell.getCellWidth() + " is different from that of previously top added cell width " + previousTopRowCell.getCellWidth() + ".");
                }
            }
        }
        if (columnIndex > 0) {
            MatrixCell previousLeftColumnCell = this.internal[rowIndex][columnIndex - 1];
            if (matrixCell.getCellHeight() != previousLeftColumnCell.getCellHeight()) {
                canThrowException = true;
                if (rowIndex == this.rowCount - 1 && doNotValidateLastRowHeight) {
                    canThrowException = false;
                }
                if (canThrowException) {
                    throw new IllegalArgumentException("Cell height " + matrixCell.getCellHeight() + " is different from that of previously left added cell height " + previousLeftColumnCell.getCellHeight() + ".");
                }
            }
        }
        if ((cell = this.internal[rowIndex][columnIndex]) != null) {
            throw new IllegalArgumentException("The cell from row index " + rowIndex + " and column index " + columnIndex + " has already a value.");
        }
        this.internal[rowIndex][columnIndex] = matrixCell;
    }

    public static interface MatrixCell {
        public int getCellWidth();

        public int getCellHeight();
    }
}

