/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.jexp.impl;

import org.esa.snap.core.jexp.EvalEnv;
import org.esa.snap.core.jexp.Symbol;
import org.esa.snap.core.jexp.Term;

public abstract class AbstractSymbol
implements Symbol {
    private final String name;
    private final int retType;

    protected AbstractSymbol(String name, int retType) {
        this.name = name.intern();
        this.retType = retType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRetType() {
        return this.retType;
    }

    @Override
    public boolean isConst() {
        return false;
    }

    public static abstract class D
    extends AbstractSymbol {
        protected D(String name) {
            super(name, 3);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return Term.toB(this.evalD(env));
        }

        @Override
        public int evalI(EvalEnv env) {
            return Term.toI(this.evalD(env));
        }

        @Override
        public String evalS(EvalEnv env) {
            return Term.toS(this.evalD(env));
        }
    }

    public static abstract class I
    extends AbstractSymbol {
        protected I(String name) {
            super(name, 2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return Term.toB(this.evalI(env));
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.evalI(env);
        }

        @Override
        public String evalS(EvalEnv env) {
            return Term.toS(this.evalI(env));
        }
    }

    public static abstract class B
    extends AbstractSymbol {
        protected B(String name) {
            super(name, 1);
        }

        @Override
        public int evalI(EvalEnv env) {
            return Term.toI(this.evalB(env));
        }

        @Override
        public double evalD(EvalEnv env) {
            return Term.toD(this.evalB(env));
        }

        @Override
        public String evalS(EvalEnv env) {
            return Term.toS(this.evalB(env));
        }
    }
}

