/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.jexp.impl;

import org.esa.snap.core.jexp.EvalEnv;
import org.esa.snap.core.jexp.Function;
import org.esa.snap.core.jexp.Namespace;
import org.esa.snap.core.jexp.Symbol;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.jexp.impl.AbstractFunction;
import org.esa.snap.core.jexp.impl.Functions;
import org.esa.snap.core.jexp.impl.NamespaceImpl;
import org.esa.snap.core.jexp.impl.Symbols;

public final class DefaultNamespace
extends NamespaceImpl {
    public DefaultNamespace() {
        this(null);
    }

    public DefaultNamespace(Namespace parent) {
        super(parent);
        this.registerDefaultSymbols();
        this.registerDefaultFunctions();
    }

    private void registerDefaultSymbols() {
        for (Symbol symbol : Symbols.getAll()) {
            this.registerSymbol(symbol);
        }
    }

    private void registerDefaultFunctions() {
        for (Function function : Functions.getAll()) {
            this.registerFunction(function);
        }
        this.registerFunction(new AbstractFunction.D("distance_deriv", -1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                double sqrSum = 0.0;
                int n = args.length / 2;
                for (int i = 0; i < n - 1; ++i) {
                    double v1 = args[i + 1].evalD(env) - args[i].evalD(env);
                    double v2 = args[i + n + 1].evalD(env) - args[i + n].evalD(env);
                    sqrSum += (v1 - v2) * (v1 - v2);
                }
                return Math.sqrt(sqrSum);
            }
        });
        this.registerFunction(new AbstractFunction.D("distance_integ", -1){

            @Override
            public double evalD(EvalEnv env, Term[] args) {
                double sqrSum = 0.0;
                double v1Sum = 0.0;
                double v2Sum = 0.0;
                int n = args.length / 2;
                for (int i = 0; i < n; ++i) {
                    sqrSum += ((v2Sum += args[i + n].evalD(env)) - (v1Sum += args[i].evalD(env))) * (v2Sum - v1Sum);
                }
                return Math.sqrt(sqrSum);
            }
        });
        this.registerFunction(new AbstractFunction.B("inrange", -1){

            @Override
            public boolean evalB(EvalEnv env, Term[] args) {
                int n1 = args.length / 3;
                int n2 = n1 + args.length / 3;
                for (int i = 0; i < n1; ++i) {
                    double v = args[i].evalD(env);
                    double v1 = args[i + n1].evalD(env);
                    double v2 = args[i + n2].evalD(env);
                    if (!(v < v1) && !(v > v2)) continue;
                    return false;
                }
                return true;
            }
        });
        this.registerFunction(new AbstractFunction.B("inrange_deriv", -1){

            @Override
            public boolean evalB(EvalEnv env, Term[] args) {
                int n1 = args.length / 3;
                int n2 = 2 * n1;
                for (int i = 0; i < n1 - 1; ++i) {
                    double v = args[i + 1].evalD(env) - args[i].evalD(env);
                    double v1 = args[i + n1 + 1].evalD(env) - args[i + n1].evalD(env);
                    double v2 = args[i + n2 + 1].evalD(env) - args[i + n2].evalD(env);
                    if (!(v < v1) && !(v > v2)) continue;
                    return false;
                }
                return true;
            }
        });
        this.registerFunction(new AbstractFunction.B("inrange_integ", -1){

            @Override
            public boolean evalB(EvalEnv env, Term[] args) {
                int n1 = args.length / 3;
                int n2 = 2 * n1;
                double vSum = 0.0;
                double v1Sum = 0.0;
                double v2Sum = 0.0;
                for (int i = 0; i < n1; ++i) {
                    v2Sum += args[i + n2].evalD(env);
                    if (!((vSum += args[i].evalD(env)) < (v1Sum += args[i + n1].evalD(env))) && !(vSum > v2Sum)) continue;
                    return false;
                }
                return true;
            }
        });
    }
}

