/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.jexp.impl;

import org.esa.snap.core.jexp.EvalEnv;
import org.esa.snap.core.jexp.Symbol;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.jexp.Variable;
import org.esa.snap.core.jexp.impl.AbstractSymbol;

public final class SymbolFactory {
    private SymbolFactory() {
    }

    public static Symbol createConstant(String name, boolean value) {
        return new ConstantB(name, value);
    }

    public static Symbol createConstant(String name, int value) {
        return new ConstantI(name, value);
    }

    public static Symbol createConstant(String name, double value) {
        return new ConstantD(name, value);
    }

    public static Variable createVariable(String name, boolean value) {
        return new VariableB(name, value);
    }

    public static Variable createVariable(String name, int value) {
        return new VariableI(name, value);
    }

    public static Variable createVariable(String name, double value) {
        return new VariableD(name, value);
    }

    public static class VariableD
    extends AbstractSymbol.D
    implements Variable {
        private double value;
        private Double min;
        private Double max;
        private Double step;

        public VariableD(String name, double value) {
            this(name, value, null, null, null);
        }

        public VariableD(String name, double value, Double min, Double max, Double step) {
            super(name);
            this.value = value;
            this.min = min;
            this.max = max;
            this.step = step;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public Double getMin() {
            return this.min;
        }

        public void setMin(Double min) {
            this.min = min;
        }

        public Double getMax() {
            return this.max;
        }

        public void setMax(Double max) {
            this.max = max;
        }

        public Double getStep() {
            return this.step;
        }

        public void setStep(Double step) {
            this.step = step;
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.value;
        }

        @Override
        public void assignB(EvalEnv env, boolean v) {
            this.value = Term.toD(v);
        }

        @Override
        public void assignI(EvalEnv env, int v) {
            this.value = v;
        }

        @Override
        public void assignD(EvalEnv env, double v) {
            this.value = v;
        }

        @Override
        public boolean isConst() {
            return false;
        }
    }

    public static final class VariableI
    extends AbstractSymbol.I
    implements Variable {
        private int value;
        private Integer min;
        private Integer max;
        private Integer step;

        public VariableI(String name, int value) {
            this(name, value, null, null, null);
        }

        public VariableI(String name, int value, Integer min, Integer max, Integer step) {
            super(name);
            this.value = value;
            this.min = min;
            this.max = max;
            this.step = step;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public Integer getMin() {
            return this.min;
        }

        public void setMin(Integer min) {
            this.min = min;
        }

        public Integer getMax() {
            return this.max;
        }

        public void setMax(Integer max) {
            this.max = max;
        }

        public Integer getStep() {
            return this.step;
        }

        public void setStep(Integer step) {
            this.step = step;
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.value;
        }

        @Override
        public void assignB(EvalEnv env, boolean v) {
            this.value = Term.toI(v);
        }

        @Override
        public void assignI(EvalEnv env, int v) {
            this.value = v;
        }

        @Override
        public void assignD(EvalEnv env, double v) {
            this.value = Term.toI(v);
        }

        @Override
        public boolean isConst() {
            return false;
        }
    }

    public static final class VariableB
    extends AbstractSymbol.B
    implements Variable {
        private boolean value;

        public VariableB(String name, boolean value) {
            super(name);
            this.value = value;
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.value;
        }

        @Override
        public void assignB(EvalEnv env, boolean v) {
            this.value = v;
        }

        @Override
        public void assignI(EvalEnv env, int v) {
            this.value = Term.toB(v);
        }

        @Override
        public void assignD(EvalEnv env, double v) {
            this.value = Term.toB(v);
        }

        @Override
        public boolean isConst() {
            return false;
        }
    }

    public static class ConstantD
    extends AbstractSymbol.D {
        private double value;

        public ConstantD(String name, double value) {
            super(name);
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.value;
        }

        @Override
        public boolean isConst() {
            return true;
        }
    }

    public static final class ConstantI
    extends AbstractSymbol.I {
        private int value;

        public ConstantI(String name, int value) {
            super(name);
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.value;
        }

        @Override
        public boolean isConst() {
            return true;
        }
    }

    public static final class ConstantB
    extends AbstractSymbol.B {
        private boolean value;

        public ConstantB(String name, boolean value) {
            super(name);
            this.value = value;
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.value;
        }

        @Override
        public boolean isConst() {
            return true;
        }
    }
}

