/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.jexp.impl;

import com.bc.ceres.core.Assert;
import java.util.List;
import org.esa.snap.core.jexp.Symbol;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.jexp.impl.Functions;
import org.esa.snap.core.jexp.impl.TermDerivator;
import org.esa.snap.core.jexp.impl.TermOptimizer;
import org.esa.snap.core.jexp.impl.TermSimplifier;

public class TermFactory {
    public static Term c(boolean v) {
        return v ? Term.ConstB.TRUE : Term.ConstB.FALSE;
    }

    public static Term c(int v) {
        Term.ConstI t = Term.ConstI.lookup(v);
        if (t != null) {
            return t;
        }
        return new Term.ConstI(v);
    }

    public static Term c(double v) {
        Term.ConstD t = Term.ConstD.lookup(v);
        if (t != null) {
            return t;
        }
        return new Term.ConstD(v);
    }

    public static Term derivative(Term t, Symbol x) {
        return new TermDerivator(x).apply(t);
    }

    public static Term derivative(Term t, Symbol x, int n) {
        Assert.argument((n >= 0 ? 1 : 0) != 0);
        if (n == 0) {
            return t;
        }
        for (int i = 1; i <= n; ++i) {
            t = TermFactory.derivative(t, x);
        }
        return t;
    }

    public static Term simplify(Term t) {
        return new TermSimplifier().apply(t);
    }

    public static Term optimize(Term t) {
        return new TermOptimizer().apply(t);
    }

    public static Term magnitude(List<Term> vector) {
        Term result = null;
        for (Term arg : vector) {
            if (result == null) {
                result = TermFactory.sq(arg);
                continue;
            }
            result = TermFactory.add(result, TermFactory.sq(arg));
        }
        return TermFactory.sqrt(result);
    }

    public static Term sqrt(Term t) {
        return new Term.Call(Functions.SQRT, t);
    }

    public static Term ref(Symbol s) {
        return new Term.Ref(s);
    }

    public static Term sq(Term t) {
        return new Term.Call(Functions.SQ, t);
    }

    public static Term neg(Term t) {
        return new Term.Neg(t);
    }

    public static Term add(Term t1, Term t2) {
        return new Term.Add(t1, t2);
    }

    public static Term sub(Term t1, Term t2) {
        return new Term.Sub(t1, t2);
    }

    public static Term mul(Term t1, Term t2) {
        return new Term.Mul(t1, t2);
    }

    public static Term div(Term t1, Term t2) {
        return new Term.Div(t1, t2);
    }

    public static Term mod(Term t1, Term t2) {
        return new Term.Mod(t1, t2);
    }

    public static Term abs(Term t) {
        return new Term.Call(Functions.ABS_D, t);
    }

    public static Term sin(Term t) {
        return new Term.Call(Functions.SIN, t);
    }

    public static Term cos(Term t) {
        return new Term.Call(Functions.COS, t);
    }

    public static Term tan(Term t) {
        return new Term.Call(Functions.TAN, t);
    }

    public static Term pow(Term t1, Term t2) {
        return new Term.Call(Functions.POW, t1, t2);
    }

    public static Term cond(Term t1, Term t2, Term t3) {
        int type1 = t2.getRetType();
        int type2 = t3.getRetType();
        int type = TermFactory.inferType(type1, type2);
        return new Term.Cond(type, t1, t2, t3);
    }

    private static int inferType(int type1, int type2) {
        int type = type1 == type2 ? type1 : (type1 == 3 || type2 == 3 ? 3 : (type1 == 2 || type2 == 2 ? 2 : (type1 == 1 || type2 == 1 ? 1 : (type1 == 4 || type2 == 4 ? 4 : 3))));
        return type;
    }
}

