/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.layer;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.Assert;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerListener;
import com.bc.ceres.glayer.annotations.LayerTypeMetadata;
import com.bc.ceres.glayer.support.AbstractLayerListener;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelSource;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ColoredMaskImageMultiLevelSource;

@LayerTypeMetadata(name="NoDataLayerType", aliasNames={"org.esa.snap.core.layer.NoDataLayerType"})
public class NoDataLayerType
extends ImageLayer.Type {
    public static final String NO_DATA_LAYER_ID = "org.esa.snap.layers.noData";
    public static final String PROPERTY_NAME_COLOR = "color";
    public static final String PROPERTY_NAME_RASTER = "raster";
    public static final Color DEFAULT_COLOR = Color.ORANGE;

    public Layer createLayer(LayerContext ctx, PropertySet configuration) {
        Color color = (Color)configuration.getValue(PROPERTY_NAME_COLOR);
        Assert.notNull((Object)color, (String)PROPERTY_NAME_COLOR);
        RasterDataNode raster = (RasterDataNode)configuration.getValue(PROPERTY_NAME_RASTER);
        MultiLevelSource multiLevelSource = (MultiLevelSource)configuration.getValue("multiLevelSource");
        if (multiLevelSource == null) {
            multiLevelSource = NoDataLayerType.createMultiLevelSource(color, raster);
            configuration.setValue("multiLevelSource", (Object)multiLevelSource);
        }
        final ImageLayer noDataLayer = new ImageLayer((ImageLayer.Type)this, multiLevelSource, configuration);
        noDataLayer.addListener((LayerListener)new AbstractLayerListener(){

            public void handleLayerPropertyChanged(Layer layer, PropertyChangeEvent event) {
                if (event.getPropertyName().equals(NoDataLayerType.PROPERTY_NAME_COLOR)) {
                    NoDataLayerType.renewMultiLevelSource(noDataLayer, (Color)event.getNewValue());
                }
            }
        });
        noDataLayer.setName("No-Data Layer");
        noDataLayer.setId(NO_DATA_LAYER_ID);
        noDataLayer.setVisible(false);
        return noDataLayer;
    }

    public PropertySet createLayerConfig(LayerContext ctx) {
        PropertySet prototype = super.createLayerConfig(ctx);
        prototype.addProperty(Property.create((String)PROPERTY_NAME_RASTER, RasterDataNode.class));
        prototype.getDescriptor(PROPERTY_NAME_RASTER).setNotNull(true);
        prototype.addProperty(Property.create((String)PROPERTY_NAME_COLOR, Color.class, (Object)DEFAULT_COLOR, (boolean)true));
        return prototype;
    }

    public static void renewMultiLevelSource(ImageLayer layer, Color newColor) {
        PropertySet configuration = layer.getConfiguration();
        RasterDataNode raster = (RasterDataNode)configuration.getValue(PROPERTY_NAME_RASTER);
        MultiLevelSource source = NoDataLayerType.createMultiLevelSource(newColor, raster);
        configuration.setValue("multiLevelSource", (Object)source);
        layer.setMultiLevelSource(source);
    }

    private static MultiLevelSource createMultiLevelSource(Color newColor, RasterDataNode raster) {
        MultiLevelSource source;
        if (raster.getValidMaskExpression() != null) {
            AffineTransform transform = raster.getSourceImage().getModel().getImageToModelTransform(0);
            source = ColoredMaskImageMultiLevelSource.create(raster.getProduct(), newColor, raster.getValidMaskExpression(), true, transform);
        } else {
            source = MultiLevelSource.NULL;
        }
        return source;
    }
}

