/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.metadata;

import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.metadata.GenericXmlMetadata;

public abstract class XmlMetadata
extends GenericXmlMetadata {
    protected int width;
    protected int height;
    protected int numBands;

    public XmlMetadata(String name) {
        super(name);
    }

    public abstract int getNumBands();

    public abstract String getProductName();

    public abstract String getFormatName();

    public abstract int getRasterWidth();

    public abstract int getRasterHeight();

    public abstract String[] getRasterFileNames();

    @Override
    public void setName(String value) {
        this.name = value;
        this.rootElement.setName(value);
    }

    public abstract ProductData.UTC getProductStartTime();

    public abstract ProductData.UTC getProductEndTime();

    public abstract ProductData.UTC getCenterTime();

    public abstract String getProductDescription();

    protected float[] asFloatArray(String value, String separator) {
        String[] values;
        float[] array = null;
        if (value != null && !value.isEmpty() && (values = value.split(separator)).length > 1) {
            array = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                array[i] = Float.parseFloat(values[i]);
            }
        }
        return array;
    }

    protected float asFloat(String value) {
        float ret = Float.NaN;
        try {
            ret = Float.parseFloat(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    protected int asInt(String value) {
        int ret = 0;
        try {
            ret = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }
}

