/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.metadata.GenericXmlMetadata;
import org.esa.snap.core.metadata.ResourceResolver;
import org.esa.snap.core.metadata.XmlMetadata;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlMetadataParser<T extends GenericXmlMetadata> {
    protected Class fileClass;
    protected String[] schemaLocations;
    protected String schemaBasePath = null;

    protected ProductData inferType(String elementName, String value) {
        return ProductData.ASCII.createInstance(value);
    }

    public XmlMetadataParser(Class metadataClass) {
        this.fileClass = metadataClass;
    }

    public T parse(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        if (this.schemaLocations != null && this.shouldValidateSchema()) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (this.schemaBasePath != null) {
                schemaFactory.setResourceResolver(new ResourceResolver(this.schemaBasePath, classLoader));
            }
            Vector<StreamSource> streamSourceList = new Vector<StreamSource>();
            for (String schemaLocation : this.schemaLocations) {
                InputStream is = classLoader.getResourceAsStream(schemaLocation);
                StreamSource streamSource = new StreamSource(is);
                streamSourceList.add(streamSource);
            }
            StreamSource[] sources = new StreamSource[streamSourceList.size()];
            Schema schema = schemaFactory.newSchema(streamSourceList.toArray(sources));
            factory.setSchema(schema);
            factory.setNamespaceAware(true);
            factory.setValidating(true);
        }
        SAXParser parser = factory.newSAXParser();
        MetadataHandler handler = new MetadataHandler();
        parser.parse(inputStream, (DefaultHandler)handler);
        return handler.getResult();
    }

    public MetadataElement parse(Path file, Set<String> excludes) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        if (this.schemaLocations != null && this.shouldValidateSchema()) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (this.schemaBasePath != null) {
                schemaFactory.setResourceResolver(new ResourceResolver(this.schemaBasePath, classLoader));
            }
            Vector<StreamSource> streamSourceList = new Vector<StreamSource>();
            for (String schemaLocation : this.schemaLocations) {
                InputStream is = classLoader.getResourceAsStream(schemaLocation);
                StreamSource streamSource = new StreamSource(is);
                streamSourceList.add(streamSource);
            }
            StreamSource[] sources = new StreamSource[streamSourceList.size()];
            Schema schema = schemaFactory.newSchema(streamSourceList.toArray(sources));
            factory.setSchema(schema);
            factory.setNamespaceAware(true);
            factory.setValidating(true);
        }
        SAXParser parser = factory.newSAXParser();
        SimpleMetadataHandler handler = new SimpleMetadataHandler(excludes);
        InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
        Object object = null;
        try {
            parser.parse(inputStream, (DefaultHandler)handler);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (object != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
        return handler.getResult();
    }

    protected boolean shouldValidateSchema() {
        return false;
    }

    protected void setSchemaBasePath(String schemaBasePath) {
        this.schemaBasePath = schemaBasePath;
    }

    protected void setSchemaLocations(String[] schemaLocations) {
        this.schemaLocations = schemaLocations;
    }

    protected class SimpleMetadataHandler
    extends DefaultHandler {
        private MetadataElement rootElement;
        private Set<String> excludedElements;
        private StringBuilder buffer = new StringBuilder(512);
        private Stack<MetadataElement> elementStack;
        private Logger systemLogger;
        private String unit;

        public SimpleMetadataHandler(Set<String> excludes) {
            this.excludedElements = excludes;
        }

        public MetadataElement getResult() {
            return this.rootElement;
        }

        @Override
        public void startDocument() throws SAXException {
            this.systemLogger = Logger.getLogger(XmlMetadataParser.class.getName());
            this.elementStack = new Stack();
            this.rootElement = new MetadataElement("Metadata");
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.indexOf(":") > 0) {
                qName = qName.substring(qName.indexOf(":") + 1);
            }
            if (this.excludedElements == null || !this.excludedElements.contains(qName)) {
                MetadataElement currentElement = new MetadataElement(qName);
                this.buffer.setLength(0);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    MetadataAttribute attribute = new MetadataAttribute(attributes.getQName(i).toUpperCase(), ProductData.ASCII.createInstance(attributes.getValue(i)), false);
                    currentElement.addAttribute(attribute);
                    if (!"unit".equals(attributes.getQName(i))) continue;
                    this.unit = attributes.getValue(i);
                }
                this.elementStack.push(currentElement);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.excludedElements == null || !this.excludedElements.contains(qName)) {
                MetadataElement closingElement = this.elementStack.pop();
                if (!this.elementStack.empty()) {
                    if (this.buffer.length() > 0 && this.buffer.charAt(0) != '\n') {
                        MetadataAttribute attribute = new MetadataAttribute(closingElement.getName().toUpperCase(), XmlMetadataParser.this.inferType(qName, this.buffer.toString()), false);
                        if (this.unit != null) {
                            attribute.setUnit(this.unit);
                        }
                        this.elementStack.peek().addAttribute(attribute);
                        this.buffer.setLength(0);
                    } else {
                        this.elementStack.peek().addElement(closingElement);
                    }
                } else {
                    XmlMetadata.CopyChildElements(closingElement, this.rootElement);
                }
            }
            this.unit = null;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            String error = e.getMessage();
            if (!error.contains("no grammar found")) {
                this.systemLogger.warning(e.getMessage());
            }
        }
    }

    protected class MetadataHandler
    extends DefaultHandler {
        private T result;
        private StringBuilder buffer = new StringBuilder(512);
        private String currentPath;
        private Stack<MetadataElement> elementStack;
        private Logger systemLogger;

        protected MetadataHandler() {
        }

        public T getResult() {
            return this.result;
        }

        @Override
        public void startDocument() throws SAXException {
            this.systemLogger = Logger.getLogger(XmlMetadataParser.class.getName());
            this.elementStack = new Stack();
            try {
                Constructor ctor = XmlMetadataParser.this.fileClass.getConstructor(String.class);
                this.result = (GenericXmlMetadata)ctor.newInstance("Metadata");
                this.currentPath = "/";
            }
            catch (Exception e1) {
                try {
                    Constructor ctor = XmlMetadataParser.this.fileClass.getDeclaredConstructor(String.class);
                    this.result = (GenericXmlMetadata)ctor.newInstance("Metadata");
                    this.currentPath = "/";
                }
                catch (Exception e) {
                    this.systemLogger.severe(e.getMessage());
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.indexOf(":") > 0) {
                qName = qName.substring(qName.indexOf(":") + 1);
            }
            MetadataElement element = new MetadataElement(qName);
            this.buffer.setLength(0);
            this.currentPath = this.currentPath + qName + "/";
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    MetadataAttribute attribute = new MetadataAttribute(attributes.getQName(i), ProductData.ASCII.createInstance(attributes.getValue(i)), false);
                    element.addAttribute(attribute);
                    ((GenericXmlMetadata)this.result).indexAttribute(this.currentPath, attribute);
                }
            }
            this.elementStack.push(element);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            MetadataElement closingElement = this.elementStack.pop();
            if (!this.elementStack.empty()) {
                if (this.buffer.length() > 0 && this.buffer.charAt(0) != '\n') {
                    MetadataAttribute attribute = new MetadataAttribute(closingElement.getName(), XmlMetadataParser.this.inferType(qName, this.buffer.toString()), false);
                    this.elementStack.peek().addAttribute(attribute);
                    this.currentPath = this.removeClosingElement(this.currentPath, closingElement.getName());
                    ((GenericXmlMetadata)this.result).indexAttribute(this.currentPath, attribute);
                    this.buffer.setLength(0);
                } else {
                    this.elementStack.peek().addElement(closingElement);
                    this.currentPath = this.removeClosingElement(this.currentPath, closingElement.getName());
                }
            } else {
                XmlMetadata.CopyChildElements(closingElement, ((GenericXmlMetadata)this.result).getRootElement());
                ((GenericXmlMetadata)this.result).getRootElement().setName("Metadata");
                this.currentPath = this.removeClosingElement(this.currentPath, closingElement.getName());
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            String error = e.getMessage();
            if (!error.contains("Dimap_Document") && !error.contains("no grammar found")) {
                this.systemLogger.warning(e.getMessage());
            }
        }

        private String removeClosingElement(String path, String closingElementName) {
            int lastIndex = path.lastIndexOf(closingElementName + "/");
            if (lastIndex == -1) {
                return path;
            }
            return path.substring(0, lastIndex);
        }
    }
}

