/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.transform;

import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.transform.MathTransform2D;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.TransformException;

public class GeoCodingMathTransform
extends AbstractMathTransform
implements MathTransform2D {
    private static final TG2P G2P = new TG2P();
    private static final TP2G P2G = new TP2G();
    private static final int DIMS = 2;
    private final GeoCoding geoCoding;
    private final T t;

    public GeoCodingMathTransform(GeoCoding geoCoding) {
        this(geoCoding, G2P);
    }

    private GeoCodingMathTransform(GeoCoding geoCoding, T t) {
        this.geoCoding = geoCoding;
        this.t = t;
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return new DefaultParameterDescriptorGroup(this.getClass().getSimpleName(), new GeneralParameterDescriptor[0]);
    }

    @Override
    public int getSourceDimensions() {
        return 2;
    }

    @Override
    public int getTargetDimensions() {
        return 2;
    }

    @Override
    public MathTransform2D inverse() {
        return new GeoCodingMathTransform(this.geoCoding, this.t == G2P ? P2G : G2P);
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        this.t.transform(this.geoCoding, srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoCodingMathTransform that = (GeoCodingMathTransform)o;
        if (this.t != that.t) {
            return false;
        }
        return this.geoCoding == that.geoCoding;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.geoCoding.hashCode();
        result = 31 * result + this.t.hashCode();
        return result;
    }

    private static class TG2P
    implements T {
        private TG2P() {
        }

        @Override
        public void transform(GeoCoding geoCoding, double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            try {
                GeoPos geoPos = new GeoPos();
                PixelPos pixelPos = new PixelPos();
                for (int i = 0; i < numPts; ++i) {
                    int firstIndex = 2 * i;
                    int secondIndex = firstIndex + 1;
                    geoPos.lon = srcPts[srcOff + firstIndex];
                    geoPos.lat = srcPts[srcOff + secondIndex];
                    geoCoding.getPixelPos(geoPos, pixelPos);
                    dstPts[dstOff + firstIndex] = pixelPos.x;
                    dstPts[dstOff + secondIndex] = pixelPos.y;
                }
            }
            catch (Exception e) {
                TransformException transformException = new TransformException();
                transformException.initCause((Throwable)e);
                throw transformException;
            }
        }
    }

    private static class TP2G
    implements T {
        private TP2G() {
        }

        @Override
        public void transform(GeoCoding geoCoding, double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            try {
                GeoPos geoPos = new GeoPos();
                PixelPos pixelPos = new PixelPos();
                for (int i = 0; i < numPts; ++i) {
                    int firstIndex = 2 * i;
                    int secondIndex = firstIndex + 1;
                    pixelPos.x = srcPts[srcOff + firstIndex];
                    pixelPos.y = srcPts[srcOff + secondIndex];
                    geoCoding.getGeoPos(pixelPos, geoPos);
                    dstPts[dstOff + firstIndex] = geoPos.lon;
                    dstPts[dstOff + secondIndex] = geoPos.lat;
                }
            }
            catch (Exception e) {
                TransformException transformException = new TransformException();
                transformException.initCause((Throwable)e);
                throw transformException;
            }
        }
    }

    private static interface T {
        public void transform(GeoCoding var1, double[] var2, int var3, double[] var4, int var5, int var6) throws TransformException;
    }
}

