/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BucketMap<K extends Number, V>
implements Map<K, V> {
    private final HashMap<K[], V> map = new HashMap();

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null || !(key instanceof Number)) {
            throw new IllegalArgumentException();
        }
        boolean ret = false;
        Set<K[]> keySet = this.map.keySet();
        Number castKey = (Number)key;
        for (Number[] numberArray : keySet) {
            if (numberArray[0].longValue() > ((Number)key).longValue() || numberArray[1].longValue() < ((Number)key).longValue()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        V value = null;
        Number castKey = (Number)key;
        for (Number[] numberArray : this.map.keySet()) {
            if (numberArray[0].longValue() > ((Number)key).longValue() || numberArray[1].longValue() < ((Number)key).longValue()) continue;
            value = this.map.get(numberArray);
            break;
        }
        return value;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, key, value);
    }

    public V put(K minKey, K maxKey, V value) {
        Number[] key = this.createKey((Number)minKey, (Number)maxKey);
        for (Number[] numberArray : this.map.keySet()) {
            if ((!this.isGreaterOrEqual(numberArray[0], minKey) || !this.isLessOrEqual(minKey, numberArray[1])) && (!this.isGreaterOrEqual(numberArray[0], maxKey) || !this.isLessOrEqual(maxKey, numberArray[1]))) continue;
            throw new IllegalArgumentException("Intervals have to be disjoint");
        }
        return this.map.put((Number[][])key, value);
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public V remove(K minKey, K maxKey) {
        return this.map.remove(this.createKey((Number)minKey, (Number)maxKey));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private K[] createKey(K min, K max) {
        if (min == null || max == null) {
            throw new IllegalArgumentException();
        }
        Number[] key = (Number[])Array.newInstance(min.getClass(), 2);
        key[0] = min;
        key[1] = max;
        return key;
    }

    private boolean isLessOrEqual(K first, K second) {
        return ((Number)first).longValue() <= ((Number)second).longValue();
    }

    private boolean isLess(K first, K second) {
        return ((Number)first).longValue() < ((Number)second).longValue();
    }

    private boolean isGreaterOrEqual(K first, K second) {
        return ((Number)first).longValue() >= ((Number)second).longValue();
    }

    private boolean isGreater(K first, K second) {
        return ((Number)first).longValue() > ((Number)second).longValue();
    }
}

