/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateTimeUtils {
    public static final SimpleDateFormat ISO_8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    public static final SimpleDateFormat ISO_8601_UTC_FORMAT = (SimpleDateFormat)ISO_8601_FORMAT.clone();
    public static final double JD_OFFSET = 2440587.5;
    public static final double MJD_OFFSET = 2400000.5;
    public static final double HOURS_PER_DAY = 24.0;
    public static final double SECONDS_PER_DAY = 86400.0;
    public static final double MILLIS_PER_DAY = 8.64E7;
    public static final double MICROS_PER_DAY = 8.64E10;

    public static double jdToMJD(double jd) {
        return jd - 2400000.5;
    }

    public static double mjdToJD(double mjd) {
        return 2400000.5 + mjd;
    }

    public static Date jdToUTC(double jd) {
        long millis = Math.round((jd - 2440587.5) * 8.64E7);
        return new Date(millis);
    }

    public static double utcToJD(Date utc) {
        long millis = utc != null ? utc.getTime() : System.currentTimeMillis();
        return 2440587.5 + (double)millis / 8.64E7;
    }

    public static String utcToString(Date utc) {
        return ISO_8601_UTC_FORMAT.format(utc != null ? utc : new Date());
    }

    public static Date stringToUTC(String utc) throws ParseException {
        return ISO_8601_UTC_FORMAT.parse(utc);
    }

    static {
        Calendar calendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
        ISO_8601_UTC_FORMAT.setCalendar(calendar);
    }
}

