/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.math.Range;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;

public class GeoUtils {
    public static GeoPos[] createGeoBoundary(Product product, int step) {
        return GeoUtils.createGeoBoundary(product, null, step, true);
    }

    public static GeoPos[] createGeoBoundary(Product product, Rectangle region, int step, boolean usePixelCenter) {
        GeoCoding gc = product.getSceneGeoCoding();
        if (gc == null) {
            throw new IllegalArgumentException("Product without geo-coding.");
        }
        if (region == null) {
            region = new Rectangle(0, 0, product.getSceneRasterWidth(), product.getSceneRasterHeight());
        }
        return GeoUtils.getGeoBoundary(gc, region, step, usePixelCenter);
    }

    public static GeoPos[] createGeoBoundary(RasterDataNode raster, Rectangle region, int step) {
        return GeoUtils.createGeoBoundary(raster, region, step, true);
    }

    public static GeoPos[] createGeoBoundary(RasterDataNode rasterDataNode, Rectangle region, int step, boolean usePixelCenter) {
        GeoCoding gc = rasterDataNode.getGeoCoding();
        if (gc == null) {
            throw new IllegalArgumentException("Product without geo-coding.");
        }
        if (region == null) {
            region = new Rectangle(0, 0, rasterDataNode.getRasterWidth(), rasterDataNode.getRasterHeight());
        }
        return GeoUtils.getGeoBoundary(gc, region, step, usePixelCenter);
    }

    public static GeneralPath[] createGeoBoundaryPaths(Product product) {
        Rectangle rect = new Rectangle(0, 0, product.getSceneRasterWidth(), product.getSceneRasterHeight());
        int step = Math.min(rect.width, rect.height) / 8;
        return GeoUtils.createGeoBoundaryPaths(product, rect, step > 0 ? step : 1);
    }

    public static GeneralPath[] createGeoBoundaryPaths(RasterDataNode rasterDataNode) {
        Rectangle rect = new Rectangle(0, 0, rasterDataNode.getRasterWidth(), rasterDataNode.getRasterHeight());
        int step = Math.min(rect.width, rect.height) / 8;
        return GeoUtils.createGeoBoundaryPaths(rasterDataNode, rect, step > 0 ? step : 1, false);
    }

    public static GeneralPath[] createGeoBoundaryPaths(Product product, Rectangle region, int step) {
        boolean usePixelCenter = true;
        return GeoUtils.createGeoBoundaryPaths(product, region, step, true);
    }

    public static GeneralPath[] createGeoBoundaryPaths(Product product, Rectangle region, int step, boolean usePixelCenter) {
        GeoPos[] geoPoints = GeoUtils.createGeoBoundary(product, region, step, usePixelCenter);
        ProductUtils.normalizeGeoPolygon(geoPoints);
        ArrayList<GeneralPath> pathList = GeoUtils.assemblePathList(geoPoints);
        return pathList.toArray(new GeneralPath[0]);
    }

    public static GeneralPath[] createGeoBoundaryPaths(RasterDataNode rasterDataNode, Rectangle region, int step, boolean usePixelCenter) {
        GeoPos[] geoPoints = GeoUtils.createGeoBoundary(rasterDataNode, region, step, usePixelCenter);
        ProductUtils.normalizeGeoPolygon(geoPoints);
        ArrayList<GeneralPath> pathList = GeoUtils.assemblePathList(geoPoints);
        return pathList.toArray(new GeneralPath[0]);
    }

    public static PixelPos[] createPixelBoundary(RasterDataNode raster, Rectangle rect, int step) {
        int width = raster.getRasterWidth();
        int height = raster.getRasterHeight();
        return GeoUtils.createPixelBoundary(width, height, rect, step);
    }

    public static PixelPos[] createPixelBoundary(int rasterWidth, int rasterHeight, Rectangle rect, int step) {
        if (rect == null) {
            rect = new Rectangle(0, 0, rasterWidth, rasterHeight);
        }
        return GeoUtils.createPixelBoundaryFromRect(rect, step);
    }

    public static PixelPos[] createPixelBoundaryFromRect(Rectangle rect, int step) {
        boolean usePixelCenter = true;
        return GeoUtils.createPixelBoundaryFromRect(rect, step, true);
    }

    private static GeoPos[] getGeoBoundary(GeoCoding gc, Rectangle region, int step, boolean usePixelCenter) {
        PixelPos[] points = GeoUtils.createPixelBoundaryFromRect(region, step, usePixelCenter);
        ArrayList<Object> geoPoints = new ArrayList(points.length);
        boolean calculateInsets = false;
        for (PixelPos pixelPos : points) {
            GeoPos gcGeoPos = gc.getGeoPos(pixelPos, null);
            if (!gcGeoPos.isValid()) {
                calculateInsets = true;
                break;
            }
            geoPoints.add(gcGeoPos);
        }
        if (calculateInsets) {
            geoPoints.clear();
            geoPoints = GeoUtils.createInsetsGeoBoundary(gc, step, region, usePixelCenter);
        }
        return geoPoints.toArray(new GeoPos[0]);
    }

    private static ArrayList<GeoPos> createInsetsGeoBoundary(GeoCoding gc, int step, Rectangle rect, boolean usePixelCenter) {
        int x;
        double yPos;
        int y;
        GeoPos geoPos;
        PixelPos pixelPos;
        double insetDistance = usePixelCenter ? 0.5 : 0.0;
        int xStart = rect.x;
        int yStart = rect.y;
        int w = usePixelCenter ? rect.width - 1 : rect.width;
        int h = usePixelCenter ? rect.height - 1 : rect.height;
        int xEnd = xStart + w;
        int yEnd = yStart + h;
        ArrayList<GeoPos> geoPosList = new ArrayList<GeoPos>();
        int validYMin = GeoUtils.getFirstValid_Y(gc, insetDistance, xStart, yStart, xEnd, yEnd);
        if (validYMin >= yEnd) {
            return geoPosList;
        }
        int validYMax = GeoUtils.getLastValid_Y(gc, insetDistance, xStart, yStart, xEnd, yEnd);
        if (validYMax <= validYMin) {
            return geoPosList;
        }
        yStart = validYMin;
        yEnd = validYMax;
        int validXMin = GeoUtils.getFirstValid_X(gc, insetDistance, xStart, yStart, xEnd, yEnd);
        if (validXMin >= xEnd) {
            return geoPosList;
        }
        int validXMax = GeoUtils.getLastValid_X(gc, insetDistance, xStart, yStart, xEnd, yEnd);
        if (validXMax <= validXMin) {
            return geoPosList;
        }
        xStart = validXMin;
        xEnd = validXMax;
        int lastX = 0;
        for (int x2 = xStart; x2 < xEnd; x2 += step) {
            double xPos = (double)x2 + insetDistance;
            pixelPos = new PixelPos(xPos, (double)yStart + insetDistance);
            geoPos = gc.getGeoPos(pixelPos, null);
            if (geoPos.isValid()) {
                geoPosList.add(geoPos);
            } else {
                for (int y2 = yStart + 1; y2 < yEnd; ++y2) {
                    pixelPos = new PixelPos(xPos, (double)y2 + insetDistance);
                    geoPos = gc.getGeoPos(pixelPos, null);
                    if (!geoPos.isValid()) continue;
                    geoPosList.add(geoPos);
                    break;
                }
            }
            lastX = x2;
        }
        int lastY = 0;
        for (y = yStart; y < yEnd; y += step) {
            yPos = (double)y + insetDistance;
            pixelPos = new PixelPos(xEnd, yPos);
            geoPos = gc.getGeoPos(pixelPos, null);
            if (geoPos.isValid()) {
                geoPosList.add(geoPos);
            } else {
                for (x = xEnd; x >= xStart; --x) {
                    pixelPos = new PixelPos(x, yPos);
                    geoPos = gc.getGeoPos(pixelPos, null);
                    if (!geoPos.isValid()) continue;
                    geoPosList.add(geoPos);
                    break;
                }
            }
            lastY = y;
        }
        pixelPos = new PixelPos(xEnd, yEnd);
        geoPos = gc.getGeoPos(pixelPos, null);
        if (geoPos.isValid()) {
            geoPosList.add(geoPos);
        }
        block4: for (int x3 = lastX; x3 > xStart; x3 -= step) {
            double xPos = (double)x3 + insetDistance;
            pixelPos = new PixelPos(xPos, (double)yEnd + insetDistance);
            geoPos = gc.getGeoPos(pixelPos, null);
            if (geoPos.isValid()) {
                geoPosList.add(geoPos);
                continue;
            }
            for (int y3 = yEnd - 1; y3 >= yStart; --y3) {
                pixelPos = new PixelPos(xPos, (double)y3 + insetDistance);
                geoPos = gc.getGeoPos(pixelPos, null);
                if (!geoPos.isValid()) continue;
                geoPosList.add(geoPos);
                continue block4;
            }
        }
        pixelPos = new PixelPos(xStart, yEnd);
        geoPos = gc.getGeoPos(pixelPos, null);
        if (geoPos.isValid()) {
            geoPosList.add(geoPos);
        }
        block6: for (y = lastY; y > yStart; y -= step) {
            yPos = (double)y + insetDistance;
            pixelPos = new PixelPos((double)xStart + insetDistance, yPos);
            geoPos = gc.getGeoPos(pixelPos, null);
            if (geoPos.isValid()) {
                geoPosList.add(geoPos);
                continue;
            }
            for (x = xStart; x < xEnd; ++x) {
                pixelPos = new PixelPos((double)x + insetDistance, yPos);
                geoPos = gc.getGeoPos(pixelPos, null);
                if (!geoPos.isValid()) continue;
                geoPosList.add(geoPos);
                continue block6;
            }
        }
        return geoPosList;
    }

    private static int getFirstValid_Y(GeoCoding gc, double insetDistance, int xStart, int yStart, int xEnd, int yEnd) {
        for (int y = yStart; y < yEnd; ++y) {
            for (int x = xStart; x < xEnd; ++x) {
                PixelPos pixelPos = new PixelPos((double)x + insetDistance, (double)y + insetDistance);
                GeoPos geoPos = gc.getGeoPos(pixelPos, null);
                if (!geoPos.isValid()) continue;
                return y;
            }
        }
        return yEnd;
    }

    private static int getLastValid_Y(GeoCoding gc, double insetDistance, int xStart, int yStart, int xEnd, int yEnd) {
        for (int y = yEnd; y >= yStart; --y) {
            for (int x = xStart; x < xEnd; ++x) {
                PixelPos pixelPos = new PixelPos((double)x + insetDistance, (double)y + insetDistance);
                GeoPos geoPos = gc.getGeoPos(pixelPos, null);
                if (!geoPos.isValid()) continue;
                return y;
            }
        }
        return yStart;
    }

    private static int getFirstValid_X(GeoCoding gc, double insetDistance, int xStart, int yStart, int xEnd, int yEnd) {
        for (int x = xStart; x < xEnd; ++x) {
            for (int y = yStart; y < yEnd; ++y) {
                PixelPos pixelPos = new PixelPos((double)x + insetDistance, (double)y + insetDistance);
                GeoPos geoPos = gc.getGeoPos(pixelPos, null);
                if (!geoPos.isValid()) continue;
                return x;
            }
        }
        return xEnd;
    }

    private static int getLastValid_X(GeoCoding gc, double insetDistance, int xStart, int yStart, int xEnd, int yEnd) {
        for (int x = xEnd; x >= xStart; --x) {
            for (int y = yStart; y < yEnd; ++y) {
                PixelPos pixelPos = new PixelPos((double)x + insetDistance, (double)y + insetDistance);
                GeoPos geoPos = gc.getGeoPos(pixelPos, null);
                if (!geoPos.isValid()) continue;
                return x;
            }
        }
        return xEnd;
    }

    static PixelPos[] createPixelBoundaryFromRect(Rectangle rect, int step, boolean usePixelCenter) {
        int y;
        double insetDistance = usePixelCenter ? 0.5 : 0.0;
        int x1 = rect.x;
        int y1 = rect.y;
        int w = usePixelCenter ? rect.width - 1 : rect.width;
        int h = usePixelCenter ? rect.height - 1 : rect.height;
        int x2 = x1 + w;
        int y2 = y1 + h;
        if (step <= 0) {
            step = 2 * Math.max(rect.width, rect.height);
        }
        ArrayList<PixelPos> pixelPosList = new ArrayList<PixelPos>(2 * (rect.width + rect.height) / step + 10);
        int lastX = 0;
        for (int x = x1; x < x2; x += step) {
            pixelPosList.add(new PixelPos((double)x + insetDistance, (double)y1 + insetDistance));
            lastX = x;
        }
        int lastY = 0;
        for (y = y1; y < y2; y += step) {
            pixelPosList.add(new PixelPos((double)x2 + insetDistance, (double)y + insetDistance));
            lastY = y;
        }
        pixelPosList.add(new PixelPos((double)x2 + insetDistance, (double)y2 + insetDistance));
        for (int x = lastX; x > x1; x -= step) {
            pixelPosList.add(new PixelPos((double)x + insetDistance, (double)y2 + insetDistance));
        }
        pixelPosList.add(new PixelPos((double)x1 + insetDistance, (double)y2 + insetDistance));
        for (y = lastY; y > y1; y -= step) {
            pixelPosList.add(new PixelPos((double)x1 + insetDistance, (double)y + insetDistance));
        }
        return pixelPosList.toArray(new PixelPos[0]);
    }

    static ArrayList<GeneralPath> assemblePathList(GeoPos[] geoPoints) {
        ArrayList<GeneralPath> pathList = new ArrayList<GeneralPath>(16);
        if (geoPoints.length > 1) {
            GeneralPath path = new GeneralPath(1, geoPoints.length + 8);
            Range range = GeoUtils.fillPath(geoPoints, path);
            int runIndexMin = (int)Math.floor((range.getMin() + 180.0) / 360.0);
            int runIndexMax = (int)Math.floor((range.getMax() + 180.0) / 360.0);
            if (runIndexMin == 0 && runIndexMax == 0) {
                pathList.add(path);
                return pathList;
            }
            Area pathArea = new Area(path);
            for (int k = runIndexMin; k <= runIndexMax; ++k) {
                Area currentArea = new Area(new Rectangle2D.Double((double)k * 360.0 - 180.0, -90.0, 360.0, 180.0));
                currentArea.intersect(pathArea);
                if (currentArea.isEmpty()) continue;
                pathList.addAll(GeoUtils.areaToSubPaths(currentArea, (double)(-k) * 360.0));
            }
        }
        return pathList;
    }

    static Range fillPath(GeoPos[] geoPoints, GeneralPath path) {
        double lon = geoPoints[0].getLon();
        Range range = new Range(lon, lon);
        path.moveTo(lon, geoPoints[0].getLat());
        for (int i = 1; i < geoPoints.length; ++i) {
            if (!geoPoints[i].isValid()) continue;
            lon = geoPoints[i].getLon();
            double lat = geoPoints[i].getLat();
            if (lon < range.getMin()) {
                range.setMin(lon);
            }
            if (lon > range.getMax()) {
                range.setMax(lon);
            }
            path.lineTo(lon, lat);
        }
        path.closePath();
        return range;
    }

    public static List<GeneralPath> areaToSubPaths(Area area, double deltaX) {
        ArrayList<GeneralPath> subPaths = new ArrayList<GeneralPath>();
        float[] floats = new float[6];
        AffineTransform transform = AffineTransform.getTranslateInstance(deltaX, 0.0);
        PathIterator iterator = area.getPathIterator(transform);
        GeneralPath pixelPath = null;
        while (!iterator.isDone()) {
            if (pixelPath == null) {
                pixelPath = new GeneralPath(1);
            }
            int segmentType = iterator.currentSegment(floats);
            switch (segmentType) {
                case 1: {
                    pixelPath.lineTo(floats[0], floats[1]);
                    break;
                }
                case 0: {
                    pixelPath.moveTo(floats[0], floats[1]);
                    break;
                }
                case 4: {
                    pixelPath.closePath();
                    subPaths.add(pixelPath);
                    pixelPath = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("unhandled segment type in path iterator: " + segmentType);
                }
            }
            iterator.next();
        }
        return subPaths;
    }

    private static Polygon convertAwtPathToJtsPolygon(Path2D path, GeometryFactory factory) {
        PathIterator pathIterator = path.getPathIterator(null);
        ArrayList<Object> coordList = new ArrayList<Object>();
        int lastOpenIndex = 0;
        while (!pathIterator.isDone()) {
            double[] coords = new double[6];
            int segType = pathIterator.currentSegment(coords);
            if (segType == 4) {
                coordList.add(coordList.get(lastOpenIndex));
                lastOpenIndex = coordList.size();
            } else {
                coordList.add(coords);
            }
            pathIterator.next();
        }
        Coordinate[] coordinates = new Coordinate[coordList.size()];
        for (int i1 = 0; i1 < coordinates.length; ++i1) {
            double[] coord = (double[])coordList.get(i1);
            coordinates[i1] = new Coordinate(coord[0], coord[1]);
        }
        return factory.createPolygon(factory.createLinearRing(coordinates), null);
    }

    public static Rectangle computePixelRegionUsingGeometry(GeoCoding rasterGeoCoding, int rasterWidth, int rasterHeight, Geometry geometryRegion, int numBorderPixels, boolean roundPixelRegion, boolean multiSize) {
        Geometry rasterGeometry = GeoUtils.computeRasterGeometry(rasterGeoCoding, rasterWidth, rasterHeight, roundPixelRegion, multiSize);
        Geometry regionIntersection = geometryRegion.intersection(rasterGeometry);
        if (regionIntersection.isEmpty()) {
            return new Rectangle();
        }
        PixelRegionFinder pixelRegionFinder = new PixelRegionFinder(rasterGeoCoding, roundPixelRegion);
        regionIntersection.apply((CoordinateFilter)pixelRegionFinder);
        Rectangle pixelRegion = pixelRegionFinder.getPixelRegion();
        pixelRegion.grow(numBorderPixels, numBorderPixels);
        Rectangle intersectedRect = pixelRegion.intersection(new Rectangle(rasterWidth, rasterHeight));
        if (intersectedRect.width * intersectedRect.height == 0 && !regionIntersection.isEmpty()) {
            return new Rectangle(intersectedRect.x, intersectedRect.y, 1, 1);
        }
        return intersectedRect;
    }

    public static Geometry computeGeometryUsingPixelRegion(GeoCoding rasterGeoCoding, Rectangle pixelRegion) {
        if (pixelRegion == null) {
            throw new NullPointerException("The pixel region is null.");
        }
        int step = Math.min(pixelRegion.width, pixelRegion.height) / 8;
        GeneralPath[] paths = GeoUtils.createGeoBoundaryPaths(rasterGeoCoding, pixelRegion, step, false);
        Polygon[] polygons = new Polygon[paths.length];
        GeometryFactory factory = new GeometryFactory();
        for (int i = 0; i < paths.length; ++i) {
            polygons[i] = GeoUtils.convertAwtPathToJtsPolygon(paths[i], factory);
        }
        if (polygons.length == 1) {
            return polygons[0];
        }
        return factory.createMultiPolygon(polygons);
    }

    public static Geometry computeRasterGeometry(GeoCoding rasterGeoCoding, int rasterWidth, int rasterHeight) {
        GeneralPath[] paths = GeoUtils.createGeoBoundaryPaths(rasterGeoCoding, rasterWidth, rasterHeight);
        Polygon[] polygons = new Polygon[paths.length];
        GeometryFactory factory = new GeometryFactory();
        for (int i = 0; i < paths.length; ++i) {
            polygons[i] = GeoUtils.convertAwtPathToJtsPolygon(paths[i], factory);
        }
        DouglasPeuckerSimplifier peuckerSimplifier = new DouglasPeuckerSimplifier((Geometry)(polygons.length == 1 ? polygons[0] : factory.createMultiPolygon(polygons)));
        return peuckerSimplifier.getResultGeometry();
    }

    public static Geometry computeRasterGeometry(GeoCoding rasterGeoCoding, int rasterWidth, int rasterHeight, boolean usePixelCenter, boolean multiSize) {
        Rectangle rect = new Rectangle(0, 0, rasterWidth, rasterHeight);
        int step = Math.min(rect.width, rect.height) / 8;
        if (!multiSize) {
            usePixelCenter = true;
        }
        GeneralPath[] paths = GeoUtils.createGeoBoundaryPaths(rasterGeoCoding, rect, step > 0 ? step : 1, usePixelCenter);
        Polygon[] polygons = new Polygon[paths.length];
        GeometryFactory factory = new GeometryFactory();
        for (int i = 0; i < paths.length; ++i) {
            polygons[i] = GeoUtils.convertAwtPathToJtsPolygon(paths[i], factory);
        }
        DouglasPeuckerSimplifier peuckerSimplifier = new DouglasPeuckerSimplifier((Geometry)(polygons.length == 1 ? polygons[0] : factory.createMultiPolygon(polygons)));
        return peuckerSimplifier.getResultGeometry();
    }

    private static GeneralPath[] createGeoBoundaryPaths(GeoCoding productGeoCoding, int productWidth, int productHeight) {
        Rectangle rect = new Rectangle(0, 0, productWidth, productHeight);
        int step = Math.min(rect.width, rect.height) / 8;
        return GeoUtils.createGeoBoundaryPaths(productGeoCoding, rect, step > 0 ? step : 1, true);
    }

    private static GeoPos[] createGeoBoundary(GeoCoding geoCoding, Rectangle region, int step, boolean usePixelCenter) {
        if (geoCoding == null) {
            throw new NullPointerException("The geo coding is null.");
        }
        if (region == null) {
            throw new NullPointerException("The region is null.");
        }
        PixelPos[] points = GeoUtils.createPixelBoundaryFromRect(region, step, usePixelCenter);
        ArrayList<GeoPos> geoPoints = new ArrayList<GeoPos>(points.length);
        for (PixelPos pixelPos : points) {
            GeoPos gcGeoPos = geoCoding.getGeoPos(pixelPos, null);
            geoPoints.add(gcGeoPos);
        }
        return geoPoints.toArray(new GeoPos[geoPoints.size()]);
    }

    private static GeneralPath[] createGeoBoundaryPaths(GeoCoding geoCoding, Rectangle region, int step, boolean usePixelCenter) {
        if (geoCoding == null) {
            throw new NullPointerException("The geo coding is null.");
        }
        if (region == null) {
            throw new NullPointerException("The region is null.");
        }
        GeoPos[] geoPoints = GeoUtils.createGeoBoundary(geoCoding, region, step, usePixelCenter);
        ProductUtils.normalizeGeoPolygon(geoPoints);
        ArrayList<GeneralPath> pathList = GeoUtils.assemblePathList(geoPoints);
        return pathList.toArray(new GeneralPath[pathList.size()]);
    }

    private static class PixelRegionFinder
    implements CoordinateFilter {
        private final GeoCoding geoCoding;
        private int x1;
        private int y1;
        private int x2;
        private int y2;
        private boolean round = false;

        private PixelRegionFinder(GeoCoding geoCoding, boolean round) {
            this.geoCoding = geoCoding;
            this.x1 = Integer.MAX_VALUE;
            this.x2 = Integer.MIN_VALUE;
            this.y1 = Integer.MAX_VALUE;
            this.y2 = Integer.MIN_VALUE;
            this.round = round;
        }

        public void filter(Coordinate coordinate) {
            GeoPos geoPos = new GeoPos(coordinate.y, coordinate.x);
            PixelPos pixelPos = this.geoCoding.getPixelPos(geoPos, null);
            if (pixelPos.isValid()) {
                if (this.round) {
                    this.x1 = Math.min(this.x1, (int)Math.round(pixelPos.x));
                    this.x2 = Math.max(this.x2, (int)Math.round(pixelPos.x));
                    this.y1 = Math.min(this.y1, (int)Math.round(pixelPos.y));
                    this.y2 = Math.max(this.y2, (int)Math.round(pixelPos.y));
                } else {
                    this.x1 = Math.min(this.x1, (int)Math.floor(pixelPos.x));
                    this.x2 = Math.max(this.x2, (int)Math.ceil(pixelPos.x));
                    this.y1 = Math.min(this.y1, (int)Math.floor(pixelPos.y));
                    this.y2 = Math.max(this.y2, (int)Math.ceil(pixelPos.y));
                }
            }
        }

        public Rectangle getPixelRegion() {
            return new Rectangle(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
        }
    }
}

