/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.esa.snap.core.util.PrivilegedAccessor;
import org.esa.snap.core.util.StringUtils;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class NativeLibraryUtils {
    private static final String ENV_LIB_PATH = "java.library.path";

    public static void registerNativePaths(Path ... paths) {
        if (paths == null || paths.length == 0) {
            return;
        }
        NativeLibraryUtils.registerNativePaths(Arrays.stream(paths).map(Path::toString).collect(Collectors.toList()).toArray(new String[paths.length]));
    }

    public static void registerNativePaths(String ... paths) {
        if (paths == null || paths.length == 0) {
            return;
        }
        String propertyValue = System.getProperty(ENV_LIB_PATH);
        StringBuilder builder = new StringBuilder();
        for (String path : paths) {
            if (StringUtils.isNullOrEmpty(propertyValue) || propertyValue.contains(path) && !propertyValue.contains(path + File.separator)) continue;
            builder.append(path).append(File.pathSeparator);
        }
        propertyValue = !StringUtils.isNullOrEmpty(propertyValue) ? builder.toString() + propertyValue : builder.toString();
        System.setProperty(ENV_LIB_PATH, propertyValue);
        try {
            Method initializePathMethod = PrivilegedAccessor.getMethod(ClassLoader.class, "initializePath", new Class[]{String.class});
            initializePathMethod.setAccessible(true);
            String[] updatedUsrPaths = (String[])initializePathMethod.invoke(null, ENV_LIB_PATH);
            PrivilegedAccessor.setStaticValue(ClassLoader.class, "usr_paths", updatedUsrPaths);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadLibrary(String path, String libraryName) throws IOException {
        path = URLDecoder.decode(path, "UTF-8");
        String mappedLibName = System.mapLibraryName(libraryName);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((path = path.replace('/', File.separatorChar)).contains(".jar")) {
            int contentsSeparatorIndex = path.indexOf("!");
            String jarPath = path.substring(0, contentsSeparatorIndex);
            JarFile jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> entries = jarFile.entries();
            JarEntry jarEntry = null;
            while (entries.hasMoreElements()) {
                JarEntry currentEntry = entries.nextElement();
                if (!org.apache.commons.lang.StringUtils.containsIgnoreCase((String)currentEntry.getName(), (String)libraryName)) continue;
                jarEntry = currentEntry;
                break;
            }
            if (jarEntry == null) {
                throw new IOException(String.format("Library %s could not be found in the jar file %s", libraryName, path));
            }
            try (InputStream in = jarFile.getInputStream(jarEntry);){
                Path tmpPath = Paths.get(System.getProperty("java.io.tmpdir"), "lib", NativeLibraryUtils.getOSFamily(), mappedLibName);
                try (FileOutputStream out = FileUtils.openOutputStream((File)tmpPath.toFile());){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                path = tmpPath.toAbsolutePath().toString();
            }
        }
        if (!Files.exists(Paths.get(path, mappedLibName), new LinkOption[0])) {
            throw new IOException(String.format("Library %s could not be found in %s", mappedLibName, path));
        }
        NativeLibraryUtils.registerNativePaths(path);
        System.loadLibrary(libraryName);
    }

    public static String getOSFamily() {
        String ret;
        String sysName = System.getProperty("os.name").toLowerCase();
        String sysArch = System.getProperty("os.arch").toLowerCase();
        if (sysName.contains("windows")) {
            ret = sysArch.contains("amd64") || sysArch.contains("x86_x64") ? "win64" : "win32";
        } else if (sysName.contains("linux")) {
            ret = "linux";
        } else if (sysName.contains("mac")) {
            ret = "macosx";
        } else {
            throw new NotImplementedException();
        }
        return ret;
    }
}

