/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import org.esa.snap.core.util.io.FileUtils;

public class ResourceInstaller {
    private final Set<PosixFilePermission> rwxr_xr_x = PosixFilePermissions.fromString("rwxr-xr-x");
    private final Path sourceBasePath;
    private final Path targetDirPath;

    public ResourceInstaller(Path sourceDirPath, Path targetDirPath) {
        this.sourceBasePath = sourceDirPath;
        this.targetDirPath = targetDirPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(String patternString, ProgressMonitor pm) throws IOException {
        if (!patternString.startsWith("glob:") && !patternString.startsWith("regex:")) {
            patternString = "regex:" + patternString;
        }
        pm.beginTask("Installing resources...", 100);
        try {
            Collection<Path> resources = this.collectResources(patternString);
            pm.worked(20);
            this.copyResources(resources, (ProgressMonitor)new SubProgressMonitor(pm, 80));
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResources(Collection<Path> resources, ProgressMonitor pm) throws IOException {
        Class<ResourceInstaller> clazz = ResourceInstaller.class;
        synchronized (ResourceInstaller.class) {
            pm.beginTask("Copying resources...", resources.size());
            try {
                for (Path resource : resources) {
                    Path relFilePath = this.sourceBasePath.relativize(resource);
                    String relPathString = relFilePath.toString();
                    Path targetFile = this.targetDirPath.resolve(relPathString);
                    if (this.mustInstallResource(targetFile, resource)) {
                        Path parentPath = targetFile.getParent();
                        if (parentPath == null) {
                            throw new IOException("Could not retrieve the parent directory of '" + targetFile.toString() + "'.");
                        }
                        Files.createDirectories(parentPath, new FileAttribute[0]);
                        Files.copy(resource, targetFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                        if (Files.getFileAttributeView(targetFile, PosixFileAttributeView.class, new LinkOption[0]) != null) {
                            Files.setPosixFilePermissions(targetFile, this.rwxr_xr_x);
                        }
                    }
                    pm.worked(1);
                }
            }
            finally {
                pm.done();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    boolean mustInstallResource(Path targetFile, Path resource) throws IOException {
        if (!Files.exists(targetFile, new LinkOption[0])) {
            return true;
        }
        Path realTargetFile = targetFile.toRealPath(new LinkOption[0]);
        Path realResource = resource.toRealPath(new LinkOption[0]);
        boolean sizeIsDifferent = Files.size(realTargetFile) != Files.size(realResource) && Files.size(realResource) != 0L;
        FileTime existingFileModifiedTime = Files.getLastModifiedTime(realTargetFile, new LinkOption[0]);
        FileTime newFileModifiedTime = Files.getLastModifiedTime(realResource, new LinkOption[0]);
        boolean newFileIsNewer = existingFileModifiedTime.compareTo(newFileModifiedTime) < 0 && Files.size(realResource) != 0L;
        return (newFileIsNewer || sizeIsDifferent) && Files.isRegularFile(resource, new LinkOption[0]);
    }

    private Collection<Path> collectResources(String patternString) throws IOException {
        ArrayList<Path> resources = new ArrayList<Path>();
        ResourceInstaller.collectResources(this.sourceBasePath, resources, patternString);
        return resources;
    }

    private static void collectResources(Path searchPath, Collection<Path> resourcePaths, String patternString) throws IOException {
        if (Files.isDirectory(searchPath, new LinkOption[0])) {
            PathMatcher pathMatcher = searchPath.getFileSystem().getPathMatcher(patternString);
            ResourceInstaller.collectResources(searchPath, resourcePaths, pathMatcher);
        } else {
            resourcePaths.add(searchPath);
        }
    }

    private static void collectResources(Path searchPath, Collection<Path> resourcePaths, PathMatcher pathMatcher) throws IOException {
        Stream<Path> files = Files.list(searchPath);
        files.forEach(path -> {
            if (pathMatcher.matches((Path)path)) {
                resourcePaths.add((Path)path);
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                try {
                    ResourceInstaller.collectResources(path, resourcePaths, pathMatcher);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static Path findModuleCodeBasePath(Class clazz) {
        try {
            URI uri = clazz.getProtectionDomain().getCodeSource().getLocation().toURI();
            return FileUtils.getPathFromURI(FileUtils.ensureJarURI(uri));
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Failed to detect the module's code base path", e);
        }
    }
}

