/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import org.esa.snap.core.util.math.MathUtils;

public class ShapeRasterizer {
    private AffineTransform transform;
    private double flatness;
    private LineRasterizer lineRasterizer;

    public ShapeRasterizer() {
        this(null, 1.0, new BresenhamLineRasterizer());
    }

    public ShapeRasterizer(AffineTransform transform, double flatness, LineRasterizer lineRasterizer) {
        this.transform = transform;
        this.flatness = flatness;
        this.lineRasterizer = lineRasterizer;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    public double getFlatness() {
        return this.flatness;
    }

    public void setFlatness(double flatness) {
        this.flatness = flatness;
    }

    public LineRasterizer getLineRasterizer() {
        return this.lineRasterizer;
    }

    public void setLineRasterizer(LineRasterizer lineRasterizer) {
        this.lineRasterizer = lineRasterizer;
    }

    public Point2D[] rasterize(Shape shape) {
        return this.rasterize(this.getVertices(shape));
    }

    public Point2D[] rasterize(Point2D[] vertices) {
        return this.rasterize(vertices, null);
    }

    public Point2D[] rasterize(Point2D[] vertices, int[] vertexIndexes) {
        if (vertices == null || vertices.length <= 1) {
            return vertices;
        }
        if (vertexIndexes != null && vertexIndexes.length < vertices.length) {
            throw new IllegalArgumentException("size of 'vertexIndexes' less than 'vertices'");
        }
        final LinkedList list = new LinkedList();
        final Point lastPoint = new Point();
        LinePixelVisitor visitor = new LinePixelVisitor(){

            @Override
            public void visit(int x, int y) {
                if (list.size() == 0 || lastPoint.x != x || lastPoint.y != y) {
                    lastPoint.x = x;
                    lastPoint.y = y;
                    list.add(new Point(lastPoint));
                }
            }
        };
        int x0 = MathUtils.floorInt(vertices[0].getX());
        int y0 = MathUtils.floorInt(vertices[0].getY());
        if (vertexIndexes != null) {
            vertexIndexes[0] = 0;
        }
        for (int i = 1; i < vertices.length; ++i) {
            int x1 = MathUtils.floorInt(vertices[i].getX());
            int y1 = MathUtils.floorInt(vertices[i].getY());
            this.lineRasterizer.rasterize(x0, y0, x1, y1, visitor);
            if (vertexIndexes != null) {
                vertexIndexes[i] = list.size() > 0 ? list.size() - 1 : 0;
            }
            x0 = x1;
            y0 = y1;
        }
        return list.toArray(new Point[list.size()]);
    }

    public Point2D[] getVertices(Shape shape) {
        if (shape == null) {
            return null;
        }
        LinkedList<Point2D.Float> list = new LinkedList<Point2D.Float>();
        float[] coordinates = new float[6];
        PathIterator pathIterator = shape.getPathIterator(this.transform, this.flatness);
        float x1 = 2.1474836E9f;
        float y1 = 2.1474836E9f;
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coordinates);
            if (type == 0 || type == 1) {
                float x0 = coordinates[0];
                float y0 = coordinates[1];
                if (x0 != x1 || y0 != y1) {
                    list.add(new Point2D.Float(x0, y0));
                }
                x1 = x0;
                y1 = y0;
            }
            pathIterator.next();
        }
        return list.toArray(new Point2D[list.size()]);
    }

    public static class BresenhamLineRasterizer
    implements LineRasterizer {
        @Override
        public void rasterize(int x0, int y0, int x1, int y1, LinePixelVisitor visitor) {
            int dx = x1 - x0;
            int dy = y1 - y0;
            int stepy = 1;
            int stepx = 1;
            if (dx < 0) {
                dx = -dx;
                stepx = -1;
            }
            if (dy < 0) {
                dy = -dy;
                stepy = -1;
            }
            visitor.visit(x0, y0);
            if ((dx <<= 1) > (dy <<= 1)) {
                int fraction = dy - (dx >> 1);
                while (x0 != x1) {
                    if (fraction >= 0) {
                        y0 += stepy;
                        fraction -= dx;
                    }
                    fraction += dy;
                    visitor.visit(x0 += stepx, y0);
                }
            } else {
                int fraction = dx - (dy >> 1);
                while (y0 != y1) {
                    if (fraction >= 0) {
                        x0 += stepx;
                        fraction -= dy;
                    }
                    fraction += dx;
                    visitor.visit(x0, y0 += stepy);
                }
            }
        }
    }

    public static interface LineRasterizer {
        public void rasterize(int var1, int var2, int var3, int var4, LinePixelVisitor var5);
    }

    public static interface LinePixelVisitor {
        public void visit(int var1, int var2);
    }
}

