/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.TileScheduler;
import javax.media.jai.util.ImagingListener;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ModuleMetadata;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.runtime.Config;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.util.logging.LoggerFactory;
import org.geotools.util.logging.Logging;

public class SystemUtils {
    public static final String SNAP_PARALLELISM_PROPERTY_NAME = SystemUtils.getApplicationContextId() + ".parallelism";
    public static final String SNAP_CACHE_DIR_PROPERTY_NAME = SystemUtils.getApplicationContextId() + ".cachedir";
    private static final String MANIFEST_ATTR_MODULE_NAME = "OpenIDE-Module-Name";
    private static final String MANIFEST_ATTR_MODULE_VERSION = "OpenIDE-Module-Specification-Version";
    public static final Logger LOG = Config.instance().logger();
    public static final String LS = System.getProperty("line.separator");
    private static final char _URL_DIR_SEPARATOR_CHAR = '/';
    public static final String AUXDATA_DIR_NAME = "auxdata";
    private static final String EPSG_DATABASE_DIR_NAME = "epsg-database";

    public static String getUserName() {
        return System.getProperty("user.name", "unknown");
    }

    public static File getUserHomeDir() {
        return new File(System.getProperty("user.home", "."));
    }

    public static String getApplicationHomepageUrl() {
        return Config.instance().preferences().get(SystemUtils.getApplicationContextId() + ".homepage.url", "http://step.esa.int");
    }

    public static File getApplicationDataDir() {
        return SystemUtils.getApplicationDataDir(false);
    }

    public static Path getAuxDataPath() {
        return SystemUtils.getApplicationDataDir().toPath().resolve(AUXDATA_DIR_NAME);
    }

    public static File getCacheDir() {
        String cacheDirPath = Config.instance().preferences().get(SNAP_CACHE_DIR_PROPERTY_NAME, null);
        if (cacheDirPath != null) {
            return new File(cacheDirPath);
        }
        return SystemUtils.getDefaultCacheDir();
    }

    public static File getDefaultCacheDir() {
        return new File(new File(SystemUtils.getApplicationDataDir(), "var"), "cache");
    }

    public static File getApplicationDataDir(boolean force) {
        File dir = Config.instance().userDir().toFile();
        if (force && !dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static String getApplicationContextId() {
        return Config.instance().preferences().get("snap.context", "snap");
    }

    public static String getApplicationName() {
        return Config.instance().preferences().get(SystemUtils.getApplicationContextId() + ".application.name", "SNAP");
    }

    public static File getCurrentWorkingDir() {
        return new File(System.getProperty("user.dir", "."));
    }

    public static File[] getClassPathFiles() {
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            return new File[0];
        }
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        File[] files = new File[st.countTokens()];
        try {
            for (int i = 0; i < files.length; ++i) {
                files[i] = new File(st.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return files;
    }

    public static File getApplicationHomeDir() {
        return Config.instance().installDir().toFile();
    }

    public static String getClassFileName(Class aClass) {
        Guardian.assertNotNull("aClass", aClass);
        String qualClassName = aClass.getName();
        int pos = qualClassName.lastIndexOf(46);
        String className = pos > 0 ? qualClassName.substring(pos + 1) : qualClassName;
        return className + ".class";
    }

    public static String convertToLocalPath(String urlPath) {
        Guardian.assertNotNull("urlPath", urlPath);
        if (File.separatorChar != '/' && urlPath.indexOf(47) >= 0) {
            return urlPath.replace('/', File.separatorChar);
        }
        return urlPath;
    }

    public static String createHumanReadableExceptionMessage(Exception e) {
        if (e == null) {
            return null;
        }
        String message = e.getMessage();
        if (message != null && message.length() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(Character.toUpperCase(message.charAt(0)));
            sb.append(message.substring(1));
            String[] punctuators = new String[]{".", ",", "!", "?", ";", ":"};
            boolean punctuatorFound = false;
            for (String punctuator : punctuators) {
                if (!message.endsWith(punctuator)) continue;
                punctuatorFound = true;
                break;
            }
            if (!punctuatorFound) {
                sb.append('.');
            }
            message = sb.toString();
        } else {
            message = "No message text available.";
        }
        return message;
    }

    public static void copyToClipboard(String text) {
        StringSelection selection = new StringSelection(text == null ? "" : text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard != null) {
            clipboard.setContents(selection, selection);
        } else {
            LOG.severe("failed to obtain clipboard instance");
        }
    }

    public static void copyToClipboard(Image image) {
        ImageSelection selection = new ImageSelection(image);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard != null) {
            clipboard.setContents(selection, null);
        } else {
            LOG.severe("failed to obtain clipboard instance");
        }
    }

    public static <S> Iterable<S> loadServices(Class<S> serviceType) {
        return ServiceLoader.load(serviceType);
    }

    public static <S> Iterable<S> loadServices(Class<S> serviceType, ClassLoader classLoader) {
        return ServiceLoader.load(serviceType, classLoader);
    }

    public static void init3rdPartyLibs(Class<?> cls) {
        SystemUtils.init3rdPartyLibsByCl(cls != null ? cls.getClassLoader() : Thread.currentThread().getContextClassLoader());
    }

    public static void init3rdPartyLibsByCl(ClassLoader cl) {
        SystemUtils.initJAI(cl);
        SystemUtils.initGeoTools();
        SystemUtils.initNetCdf();
    }

    private static void initNetCdf() {
        System.setProperty("org.slf4j.simplelogger.log.ucar.nc2.iosp.hdf4.H4header", "error");
    }

    public static void initGeoTools() {
        GeoTools.init((Hints)new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)true));
        Logging.ALL.setLoggerFactory((LoggerFactory)new GeoToolsLoggerFactory());
        File epsgDir = new File(SystemUtils.getApplicationDataDir(true), EPSG_DATABASE_DIR_NAME);
        System.setProperty("EPSG-HSQL.directory", epsgDir.getAbsolutePath());
        System.setProperty("hsqldb.db.level", Level.WARNING.getName());
        SnapImagingListener.registerAt(JAI.getDefaultInstance());
    }

    public static void initJAI(Class<?> cls) {
        SystemUtils.initJAI(cls != null ? cls.getClassLoader() : Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initJAI(ClassLoader cl) {
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        PrintStream originalErrStream = System.err;
        try (PrintStream nullErrStream = new PrintStream(new NullOutputStream());){
            System.setErr(nullErrStream);
            JAI.getDefaultInstance().getOperationRegistry().registerServices(cl);
        }
        catch (Throwable t) {
            LOG.fine("Failed to register additional JAI operators: " + t.getMessage());
        }
        finally {
            System.setErr(originalErrStream);
        }
        int parallelism = Config.instance().preferences().getInt(SNAP_PARALLELISM_PROPERTY_NAME, Runtime.getRuntime().availableProcessors());
        TileScheduler tileScheduler = JAI.getDefaultInstance().getTileScheduler();
        tileScheduler.setParallelism(parallelism);
        LOG.fine(MessageFormat.format("JAI tile scheduler parallelism set to {0}", parallelism));
        tileScheduler.setPrefetchParallelism(parallelism);
        LOG.fine(MessageFormat.format("JAI tile scheduler prefetch parallelism set to {0}", parallelism));
        long OneMiB = 0x100000L;
        JAI.enableDefaultTileCache();
        long size = Config.instance().preferences().getLong("snap.jai.tileCacheSize", 1024L) * OneMiB;
        JAI.getDefaultInstance().getTileCache().setMemoryCapacity(size);
        long tileCacheSize = JAI.getDefaultInstance().getTileCache().getMemoryCapacity() / OneMiB;
        LOG.fine(MessageFormat.format("JAI tile cache size is {0} MiB", tileCacheSize));
        int tileSize = Config.instance().preferences().getInt("snap.jai.defaultTileSize", 512);
        JAI.setDefaultTileSize((Dimension)new Dimension(tileSize, tileSize));
        LOG.fine(MessageFormat.format("JAI default tile size is {0} pixels", tileSize));
        JAI.getDefaultInstance().setRenderingHint(JAI.KEY_CACHED_TILE_RECYCLING_ENABLED, (Object)Boolean.TRUE);
        LOG.fine("JAI tile recycling enabled");
        SnapImagingListener.registerAt(JAI.getDefaultInstance());
    }

    public static String getApplicationRemoteVersionUrl() {
        String key = SystemUtils.getApplicationContextId() + ".remoteVersion.url";
        String applicationHomepageUrl = SystemUtils.getApplicationHomepageUrl();
        if (!applicationHomepageUrl.endsWith("/")) {
            applicationHomepageUrl = applicationHomepageUrl + "/";
        }
        return System.getProperty(key, applicationHomepageUrl + "software/version.txt");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ModuleMetadata loadModuleMetadata(Class<?> aClass) {
        try {
            URL moduleLocation = aClass.getProtectionDomain().getCodeSource().getLocation();
            Path pathFromURI = FileUtils.getPathFromURI(FileUtils.ensureJarURI(moduleLocation.toURI()));
            Path manifestPath = pathFromURI.resolve("META-INF/MANIFEST.MF");
            try (InputStream inputStream = Files.newInputStream(manifestPath, new OpenOption[0]);){
                Manifest manifest = new Manifest(inputStream);
                ManifestModuleMetadata manifestModuleMetadata = new ManifestModuleMetadata(manifest);
                return manifestModuleMetadata;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getReleaseVersion() {
        String version = null;
        Path versionFile = SystemUtils.getApplicationHomeDir().toPath().resolve("VERSION.txt");
        if (Files.exists(versionFile, new LinkOption[0])) {
            try {
                List<String> versionInfo = Files.readAllLines(versionFile);
                if (!versionInfo.isEmpty()) {
                    version = versionInfo.get(0);
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if (version != null) {
            return version;
        }
        return "[no version info, missing ${SNAP_HOME}/VERSION.txt]";
    }

    public static void freeAllMemory() {
        JAI.getDefaultInstance().getTileCache().flush();
        JAI.getDefaultInstance().getTileCache().memoryControl();
        System.gc();
        System.gc();
        System.gc();
    }

    public static double getMemoryUsed() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        double deltaBytes = runtime.totalMemory() - runtime.freeMemory();
        return deltaBytes / 1048576.0;
    }

    public static void tileCacheFreeOldTiles() {
        JAI.getDefaultInstance().getTileCache().memoryControl();
    }

    private static class SnapImagingListener
    implements ImagingListener {
        private static SnapImagingListener internal = new SnapImagingListener();

        private SnapImagingListener() {
        }

        private static void registerAt(JAI instance) {
            if (!(JAI.getDefaultInstance().getImagingListener() instanceof SnapImagingListener)) {
                instance.setImagingListener((ImagingListener)internal);
            }
        }

        public boolean errorOccurred(String message, Throwable thrown, Object where, boolean isRetryable) throws RuntimeException {
            String logMsg = String.format("JAI error occurred: '%s' at %s", message, where);
            if (message.contains("Continuing in pure Java mode")) {
                LOG.log(Level.FINER, logMsg, thrown);
                return false;
            }
            LOG.log(Level.SEVERE, logMsg, thrown);
            if (thrown instanceof RuntimeException && !(where instanceof OperationRegistry)) {
                throw (RuntimeException)thrown;
            }
            return false;
        }
    }

    private static class GeoToolsLoggerFactory
    extends LoggerFactory<Logger> {
        public GeoToolsLoggerFactory() {
            super(Logger.class);
        }

        protected Logger getImplementation(String name) {
            Logger logger = Logger.getLogger(name);
            logger.setLevel(Level.SEVERE);
            return logger;
        }

        protected Logger wrap(String name, Logger implementation) {
            return implementation;
        }

        protected Logger unwrap(Logger logger) {
            return logger;
        }
    }

    private static class ManifestModuleMetadata
    implements ModuleMetadata {
        private final Manifest manifest;

        public ManifestModuleMetadata(Manifest manifest) {
            this.manifest = manifest;
        }

        @Override
        public String getDisplayName() {
            return this.getAttributeValue(this.manifest, SystemUtils.MANIFEST_ATTR_MODULE_NAME);
        }

        @Override
        public String getSymbolicName() {
            return this.getDisplayName() + "_" + this.getVersion();
        }

        @Override
        public String getVersion() {
            return this.getAttributeValue(this.manifest, SystemUtils.MANIFEST_ATTR_MODULE_VERSION);
        }

        private String getAttributeValue(Manifest manifest, String attrName) {
            Attributes mainAttributes = manifest.getMainAttributes();
            String attrValue = mainAttributes.getValue(attrName);
            if (attrValue == null) {
                return "unknown";
            }
            return attrValue;
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    public static class ImageSelection
    implements Transferable {
        private Image _image;

        public ImageSelection(Image image) {
            this._image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this._image;
        }
    }
}

