/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.esa.snap.core.util.ThreadRunnable;

public class ThreadExecutor {
    private final ThreadPoolExecutor executor;
    private boolean debugSingleThreaded = false;
    private Runnable runnable;
    private final int numConsecutiveThreads;

    public ThreadExecutor() {
        this.numConsecutiveThreads = Runtime.getRuntime().availableProcessors() * 2;
        this.executor = this.createThreadPool(this.numConsecutiveThreads);
    }

    public ThreadExecutor(int maxThreads) {
        this.numConsecutiveThreads = maxThreads;
        this.executor = this.createThreadPool(this.numConsecutiveThreads);
    }

    private ThreadPoolExecutor createThreadPool(int maxThreads) {
        return new ThreadPoolExecutor(maxThreads, maxThreads, 300L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public int getNumConsecutiveThreads() {
        return this.numConsecutiveThreads;
    }

    public void setDebugSingleThreaded(boolean debugSingleThreaded) {
        this.debugSingleThreaded = debugSingleThreaded;
    }

    public void execute(ThreadRunnable runnable) throws Exception {
        if (this.executor.isShutdown()) {
            throw new Exception("Executor already shutdown!!");
        }
        this.runnable = runnable;
        if (this.debugSingleThreaded) {
            runnable.process();
        } else {
            this.executor.execute(runnable);
        }
    }

    public void complete() throws Exception {
        ThreadRunnable threadRunnable;
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
            Thread.sleep(50L);
        }
        if (this.runnable instanceof ThreadRunnable && (threadRunnable = (ThreadRunnable)this.runnable).hasError()) {
            if (threadRunnable.description != null) {
                System.out.println("Error in " + threadRunnable.description + ": " + threadRunnable.getException().getMessage());
                threadRunnable.getException().printStackTrace();
            }
            throw threadRunnable.getException();
        }
    }
}

