/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ConverterRegistry;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;

public class JtsGeometryConverter
implements Converter<Geometry> {
    public Class<? extends Geometry> getValueType() {
        return Geometry.class;
    }

    public Geometry parse(String text) throws ConversionException {
        if (text.isEmpty()) {
            return null;
        }
        try {
            return new WKTReader().read(text);
        }
        catch (ParseException e) {
            throw new ConversionException("Could not parse geometry.", (Throwable)e);
        }
    }

    public String format(Geometry value) {
        if (value == null) {
            return "";
        }
        return new WKTWriter().write(value);
    }

    public static void registerConverter() {
        JtsGeometryConverter geometryConverter = new JtsGeometryConverter();
        ConverterRegistry.getInstance().setConverter(Geometry.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(Point.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(MultiPoint.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(LineString.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(MultiLineString.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(LinearRing.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(Polygon.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(MultiPolygon.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(GeometryCollection.class, (Converter)geometryConverter);
    }
}

