/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.geotiff;

import com.sun.media.imageio.plugins.tiff.GeoTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jdom.Content;
import org.jdom.Element;

public class GeoTIFFMetadata {
    public static final String IIO_METADATA_FORMAT_NAME = "com_sun_media_imageio_plugins_tiff_image_1.0";
    public static final String IIO_TIFF_ROOT_ELEMENT_NAME = "com_sun_media_imageio_plugins_tiff_image_1.0";
    public static final String IIO_TIFF_IFD_ELEMENT_NAME = "TIFFIFD";
    public static final String IIO_TIFF_FIELD_ELEMENT_NAME = "TIFFField";
    public static final String IIO_TIFF_SHORT_ELEMENT_NAME = "TIFFShort";
    public static final String IIO_TIFF_SHORTS_ELEMENT_NAME = "TIFFShorts";
    public static final String IIO_TIFF_DOUBLE_ELEMENT_NAME = "TIFFDouble";
    public static final String IIO_TIFF_DOUBLES_ELEMENT_NAME = "TIFFDoubles";
    public static final String IIO_TIFF_ASCII_ELEMENT_NAME = "TIFFAscii";
    public static final String IIO_TIFF_ASCIIS_ELEMENT_NAME = "TIFFAsciis";
    public static final String IIO_TIFF_TAGSETS_ATT_NAME = "tagSets";
    public static final String IIO_TIFF_NUMBER_ATT_NAME = "number";
    public static final String IIO_TIFF_NAME_ATT_NAME = "name";
    public static final String IIO_TIFF_VALUE_ATT_NAME = "value";
    public static final String IIO_IMAGE_FORMAT_NAME = "TIFF";
    private static final int DEFAULT_GEOTIFF_VERSION = 1;
    private static final int DEFAULT_KEY_REVISION_MAJOR = 1;
    private static final int DEFAULT_KEY_REVISION_MINOR = 2;
    private static final int ARRAY_ELEM_INCREMENT = 32;
    private static final int TIFF_USHORT_MIN = 0;
    private static final int TIFF_USHORT_MAX = 65535;
    private List<TiePoint> _modelTiePoints;
    private double[] _modelPixelScale;
    private double[] _modelTransformation;
    private SortedMap<Integer, KeyEntry> _geoKeyEntries = new TreeMap<Integer, KeyEntry>();
    private int _numGeoDoubleParams;
    private double[] _geoDoubleParams = new double[32];
    private int _numGeoAsciiParams;
    private StringBuffer _geoAsciiParams = new StringBuffer();

    public GeoTIFFMetadata() {
        this(1, 1, 2);
    }

    public GeoTIFFMetadata(int geoTIFFVersion, int keyRevisionMajor, int keyRevisionMinor) {
        this._modelTiePoints = new ArrayList<TiePoint>();
        this._modelPixelScale = new double[3];
        this._modelTransformation = new double[16];
        this.setModelPixelScale(1.0, 1.0);
        this.addGeoKeyEntry(geoTIFFVersion, keyRevisionMajor, keyRevisionMinor, 0);
    }

    public static boolean isTiffUShort(int value) {
        return value >= 0 && value <= 65535;
    }

    protected static TIFFTag getGeoKeyDirectoryTag() {
        return GeoTIFFTagSet.getInstance().getTag(34735);
    }

    protected static TIFFTag getGeoDoubleParamsTag() {
        return GeoTIFFTagSet.getInstance().getTag(34736);
    }

    protected static TIFFTag getGeoAsciiParamsTag() {
        return GeoTIFFTagSet.getInstance().getTag(34737);
    }

    protected static TIFFTag getModelPixelScaleTag() {
        return GeoTIFFTagSet.getInstance().getTag(33550);
    }

    protected static TIFFTag getModelTiePointTag() {
        return GeoTIFFTagSet.getInstance().getTag(33922);
    }

    protected static TIFFTag getModelTransformationTag() {
        return GeoTIFFTagSet.getInstance().getTag(34264);
    }

    private static String toAlignedString(int value, int length) {
        return GeoTIFFMetadata.toAlignedString(String.valueOf(value), length, true);
    }

    private static String toAlignedString(double value, int length) {
        return GeoTIFFMetadata.toAlignedString(String.valueOf(value), length, true);
    }

    private static String toAlignedString(String value, int length, boolean right) {
        int n = length - value.length();
        if (n > 0) {
            char[] chars = new char[n];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = 32;
            }
            String spaces = new String(chars);
            return right ? spaces + value : value + spaces;
        }
        return value;
    }

    public int getGeoTIFFVersion() {
        return this.getGeoKeyEntryAt(0).data[0];
    }

    public void setGeoTIFFVersion(int version) {
        ((KeyEntry)this.getGeoKeyEntryAt((int)0)).data[0] = version;
    }

    public int getKeyRevisionMajor() {
        return this.getGeoKeyEntryAt(0).data[1];
    }

    public int getKeyRevisionMinor() {
        return this.getGeoKeyEntryAt(0).data[2];
    }

    public void setKeyRevision(int major, int minor) {
        ((KeyEntry)this.getGeoKeyEntryAt((int)0)).data[1] = major;
        ((KeyEntry)this.getGeoKeyEntryAt((int)0)).data[2] = minor;
    }

    public double getModelPixelScaleX() {
        return this._modelPixelScale[0];
    }

    public double getModelPixelScaleY() {
        return this._modelPixelScale[1];
    }

    public double getModelPixelScaleZ() {
        return this._modelPixelScale[2];
    }

    public void setModelPixelScale(double x, double y) {
        this.setModelPixelScale(x, y, 0.0);
    }

    public void setModelPixelScale(double x, double y, double z) {
        this._modelPixelScale[0] = x;
        this._modelPixelScale[1] = y;
        this._modelPixelScale[2] = z;
    }

    public double[] getModelPixelScale() {
        return (double[])this._modelPixelScale.clone();
    }

    public double[] getModelTransformation() {
        return (double[])this._modelTransformation.clone();
    }

    public void setModelTransformation(double[] matrix) {
        System.arraycopy(matrix, 0, this._modelTransformation, 0, 16);
    }

    public int getNumModelTiePoints() {
        return this._modelTiePoints.size();
    }

    public TiePoint getModelTiePoint() {
        return this.getModelTiePointAt(0);
    }

    public TiePoint getModelTiePointAt(int index) {
        return this._modelTiePoints.get(index);
    }

    public void setModelTiePoint(double i, double j, double x, double y) {
        this.setModelTiePoint(i, j, 0.0, x, y, 0.0);
    }

    public void setModelTiePoint(double i, double j, double k, double x, double y, double z) {
        if (this.getNumModelTiePoints() > 0) {
            this.getModelTiePointAt(0).set(i, j, k, x, y, z);
        } else {
            this.addModelTiePoint(i, j, k, x, y, z);
        }
    }

    public void addModelTiePoint(double i, double j, double x, double y) {
        this.addModelTiePoint(i, j, 0.0, x, y, 0.0);
    }

    public void addModelTiePoint(double i, double j, double k, double x, double y, double z) {
        this._modelTiePoints.add(new TiePoint(i, j, k, x, y, z));
    }

    public int getNumGeoKeyEntries() {
        return this._geoKeyEntries.size();
    }

    public KeyEntry getGeoKeyEntryAt(int index) {
        return this.getGeoKeyEntries()[index];
    }

    public KeyEntry[] getGeoKeyEntries() {
        return this._geoKeyEntries.values().toArray(new KeyEntry[this._geoKeyEntries.size()]);
    }

    public KeyEntry getGeoKeyEntry(int keyID) {
        return (KeyEntry)this._geoKeyEntries.get(keyID);
    }

    public boolean hasGeoKeyEntry(int keyID) {
        return this.getGeoKeyEntry(keyID) != null;
    }

    public int getGeoShortParam(int keyID) {
        KeyEntry entry = this.getNonNullKeyEntry(keyID);
        int[] data = entry.getData();
        int tag = data[1];
        int count = data[2];
        int value = data[3];
        this.checkParamTag(tag, 0);
        return value;
    }

    public double[] getGeoDoubleParams() {
        return Arrays.copyOf(this._geoDoubleParams, this._numGeoDoubleParams);
    }

    public double getGeoDoubleParam(int keyID) {
        KeyEntry entry = this.getNonNullKeyEntry(keyID);
        int[] data = entry.getData();
        int tag = data[1];
        int count = data[2];
        int offset = data[3];
        this.checkParamTag(tag, GeoTIFFMetadata.getGeoDoubleParamsTag().getNumber());
        return this._geoDoubleParams[offset];
    }

    public double[] getGeoDoubleParams(int keyID) {
        return this.getGeoDoubleParams(keyID, null);
    }

    public double[] getGeoDoubleParams(int keyID, double[] values) {
        KeyEntry entry = this.getNonNullKeyEntry(keyID);
        int[] data = entry.getData();
        int tag = data[1];
        int count = data[2];
        int offset = data[3];
        this.checkParamTag(tag, GeoTIFFMetadata.getGeoDoubleParamsTag().getNumber());
        if (values == null) {
            values = new double[count];
        }
        System.arraycopy(this._geoDoubleParams, offset, values, 0, count);
        return values;
    }

    public String getGeoAsciiParams() {
        return this._geoAsciiParams.toString();
    }

    public String getGeoAsciiParam(int keyID) {
        KeyEntry entry = this.getNonNullKeyEntry(keyID);
        int[] data = entry.getData();
        int tag = data[1];
        int count = data[2];
        int offset = data[3];
        this.checkParamTag(tag, GeoTIFFMetadata.getGeoAsciiParamsTag().getNumber());
        return this._geoAsciiParams.substring(offset, offset + count - 1);
    }

    public void addGeoShortParam(int keyID, int value) {
        this.addGeoKeyEntry(keyID, 0, 1, value);
    }

    public void addGeoDoubleParam(int keyID, double value) {
        this.addGeoDoubleParamsRef(keyID, 1);
        this.addDoubleParam(value);
    }

    public void addGeoDoubleParams(int keyID, double[] values) {
        this.addGeoDoubleParamsRef(keyID, values.length);
        for (double value : values) {
            this.addDoubleParam(value);
        }
    }

    public void addGeoAscii(int keyID, String value) {
        this.addGeoAsciiParamsRef(keyID, value.length() + 1);
        this.addAsciiParam(value);
    }

    private void addGeoKeyEntry(int keyID, int tag, int count, int offset) {
        if (!GeoTIFFMetadata.isTiffUShort(keyID)) {
            throw new IllegalArgumentException("keyID is not a TIFF USHORT");
        }
        if (!GeoTIFFMetadata.isTiffUShort(tag)) {
            throw new IllegalArgumentException("tag is not a TIFF USHORT");
        }
        if (!GeoTIFFMetadata.isTiffUShort(count)) {
            throw new IllegalArgumentException("count is not a TIFF USHORT");
        }
        if (!GeoTIFFMetadata.isTiffUShort(offset)) {
            throw new IllegalArgumentException("offset is not a TIFF USHORT");
        }
        this._geoKeyEntries.put(keyID, new KeyEntry(keyID, tag, count, offset));
        ((KeyEntry)this.getGeoKeyEntryAt((int)0)).data[3] = this._geoKeyEntries.size() - 1;
    }

    public void assignTo(Element element, String metadataFormatName, String classNameList) {
        Element[] childElems;
        if (!element.getName().equals(metadataFormatName)) {
            throw new IllegalArgumentException("root not found: " + metadataFormatName);
        }
        Element ifd1 = element.getChild(IIO_TIFF_IFD_ELEMENT_NAME);
        if (ifd1 == null) {
            throw new IllegalArgumentException("child not found: TIFFIFD");
        }
        Element ifd2 = this.createIFD(classNameList);
        ifd1.setAttribute(IIO_TIFF_TAGSETS_ATT_NAME, ifd2.getAttributeValue(IIO_TIFF_TAGSETS_ATT_NAME));
        for (Element child : childElems = ifd2.getChildren().toArray(new Element[0])) {
            ifd2.removeContent((Content)child);
            ifd1.addContent((Content)child);
        }
    }

    public Element createRootTree(String classNameList) {
        Element rootElement = new Element("com_sun_media_imageio_plugins_tiff_image_1.0");
        rootElement.addContent((Content)this.createIFD(classNameList));
        return rootElement;
    }

    public void dump() {
        try (PrintWriter writer = new PrintWriter(System.out);){
            this.dump(writer);
            writer.flush();
        }
    }

    public void dump(PrintWriter out) {
        int i;
        String indent = "    ";
        out.println();
        out.println(GeoTIFFMetadata.getGeoKeyDirectoryTag().getName() + " = { // " + GeoTIFFMetadata.getGeoKeyDirectoryTag().getNumber());
        for (i = 0; i < this.getNumGeoKeyEntries(); ++i) {
            out.print("    ");
            out.print("{");
            out.print(GeoTIFFMetadata.toAlignedString(this.getGeoKeyEntryAt(i).data[0], 6));
            out.print(",");
            out.print(GeoTIFFMetadata.toAlignedString(this.getGeoKeyEntryAt(i).data[1], 6));
            out.print(",");
            out.print(GeoTIFFMetadata.toAlignedString(this.getGeoKeyEntryAt(i).data[2], 3));
            out.print(",");
            out.print(GeoTIFFMetadata.toAlignedString(this.getGeoKeyEntryAt(i).data[3], 6));
            out.print("}");
            out.print(i < this.getNumGeoKeyEntries() - 1 ? "," : " ");
            out.print(" // ");
            out.print(GeoTIFFMetadata.toAlignedString(i, 2));
            out.println();
        }
        out.println("};");
        out.println();
        out.println(GeoTIFFMetadata.getGeoDoubleParamsTag().getName() + " = { // " + GeoTIFFMetadata.getGeoDoubleParamsTag().getNumber());
        for (i = 0; i < this._numGeoDoubleParams; ++i) {
            out.print("    ");
            out.print(GeoTIFFMetadata.toAlignedString(this._geoDoubleParams[i], 12));
            out.print(i < this._numGeoDoubleParams - 1 ? "," : " ");
            out.print(" // ");
            out.print(GeoTIFFMetadata.toAlignedString(i, 2));
            out.println();
        }
        out.println("};");
        out.println();
        out.println(GeoTIFFMetadata.getGeoAsciiParamsTag().getName() + " = // " + GeoTIFFMetadata.getGeoAsciiParamsTag().getNumber());
        out.print("    ");
        out.print("\"");
        out.print(this._geoAsciiParams);
        out.print("\"");
        out.println("};");
        out.println();
    }

    private KeyEntry getNonNullKeyEntry(int keyID) {
        KeyEntry entry = this.getGeoKeyEntry(keyID);
        if (entry == null) {
            throw new IllegalArgumentException("entry not found for geo key " + keyID);
        }
        return entry;
    }

    private void checkParamTag(int tag, int expectedTag) {
        if (tag != expectedTag) {
            if (expectedTag == 0) {
                throw new IllegalArgumentException("invalid key access, not a GeoTIFF SHORT parameter");
            }
            if (expectedTag == GeoTIFFMetadata.getGeoDoubleParamsTag().getNumber()) {
                throw new IllegalArgumentException("invalid key access, not a GeoTIFF DOUBLE parameter");
            }
            if (expectedTag == GeoTIFFMetadata.getGeoAsciiParamsTag().getNumber()) {
                throw new IllegalArgumentException("invalid key access, not a GeoTIFF ASCII parameter");
            }
            throw new IllegalStateException();
        }
    }

    private void addDoubleParam(double param) {
        int numDoubleParams = this._numGeoDoubleParams;
        if (numDoubleParams >= this._geoDoubleParams.length - 1) {
            double[] doubleParams = new double[numDoubleParams + 32];
            System.arraycopy(this._geoDoubleParams, 0, doubleParams, 0, numDoubleParams);
            this._geoDoubleParams = doubleParams;
        }
        this._geoDoubleParams[numDoubleParams] = param;
        ++this._numGeoDoubleParams;
    }

    private void addAsciiParam(String param) {
        this._geoAsciiParams.append(param);
        this._geoAsciiParams.append('|');
        ++this._numGeoAsciiParams;
    }

    private void addGeoDoubleParamsRef(int keyID, int count) {
        this.addGeoKeyEntry(keyID, GeoTIFFMetadata.getGeoDoubleParamsTag().getNumber(), count, this.getCurrentGeoDoublesOffset());
    }

    private void addGeoAsciiParamsRef(int keyID, int length) {
        this.addGeoKeyEntry(keyID, GeoTIFFMetadata.getGeoAsciiParamsTag().getNumber(), length, this.getCurrentGeoAsciisOffset());
    }

    private int getCurrentGeoDoublesOffset() {
        return this._numGeoDoubleParams;
    }

    private int getCurrentGeoAsciisOffset() {
        return this._geoAsciiParams.length();
    }

    private Element createIFD(String classNameList) {
        Element ifd = new Element(IIO_TIFF_IFD_ELEMENT_NAME);
        ifd.setAttribute(IIO_TIFF_TAGSETS_ATT_NAME, classNameList);
        if (this.isModelPixelScaleSet()) {
            ifd.addContent((Content)this.createModelPixelScaleElement());
        }
        if (this.hasModelTiePoints()) {
            ifd.addContent((Content)this.createModelTiePointsElement());
        }
        if (this.isModelTransformationSet()) {
            ifd.addContent((Content)this.createModelTransformationElement());
        }
        if (this.getNumGeoKeyEntries() > 1) {
            ifd.addContent((Content)this.createGeoKeyDirectoryElement());
        }
        if (this._numGeoDoubleParams > 0) {
            ifd.addContent((Content)this.createGeoDoubleParamsElement());
        }
        if (this._numGeoAsciiParams > 0) {
            ifd.addContent((Content)this.createGeoAsciiParamsElement());
        }
        return ifd;
    }

    private boolean isModelPixelScaleSet() {
        for (double scale : this._modelPixelScale) {
            if (scale == 0.0 || scale == 1.0) continue;
            return true;
        }
        return false;
    }

    private boolean hasModelTiePoints() {
        return this._modelTiePoints.size() > 0;
    }

    private boolean isModelTransformationSet() {
        for (double trans : this._modelTransformation) {
            if (trans == 0.0) continue;
            return true;
        }
        return false;
    }

    private Element createGeoKeyDirectoryElement() {
        Element field = this.createFieldElement(GeoTIFFMetadata.getGeoKeyDirectoryTag());
        Element data = new Element(IIO_TIFF_SHORTS_ELEMENT_NAME);
        field.addContent((Content)data);
        for (int i = 0; i < this.getNumGeoKeyEntries(); ++i) {
            int[] values;
            for (int value : values = this.getGeoKeyEntryAt(i).data) {
                Element keyEntry = this.createShortElement(value);
                data.addContent((Content)keyEntry);
            }
        }
        return field;
    }

    private Element createGeoDoubleParamsElement() {
        Element field = this.createFieldElement(GeoTIFFMetadata.getGeoDoubleParamsTag());
        Element data = new Element(IIO_TIFF_DOUBLES_ELEMENT_NAME);
        field.addContent((Content)data);
        for (int i = 0; i < this._numGeoDoubleParams; ++i) {
            Element param = this.createDoubleElement(this._geoDoubleParams[i]);
            data.addContent((Content)param);
        }
        return field;
    }

    private Element createGeoAsciiParamsElement() {
        Element field = this.createFieldElement(GeoTIFFMetadata.getGeoAsciiParamsTag());
        Element data = new Element(IIO_TIFF_ASCIIS_ELEMENT_NAME);
        field.addContent((Content)data);
        data.addContent((Content)this.createAsciiElement(this._geoAsciiParams.toString()));
        return field;
    }

    private Element createModelPixelScaleElement() {
        Element field = this.createFieldElement(GeoTIFFMetadata.getModelPixelScaleTag());
        Element data = new Element(IIO_TIFF_DOUBLES_ELEMENT_NAME);
        field.addContent((Content)data);
        this.addDoubleElements(data, this._modelPixelScale);
        return field;
    }

    private Element createModelTransformationElement() {
        Element field = this.createFieldElement(GeoTIFFMetadata.getModelTransformationTag());
        Element data = new Element(IIO_TIFF_DOUBLES_ELEMENT_NAME);
        field.addContent((Content)data);
        this.addDoubleElements(data, this._modelTransformation);
        return field;
    }

    private Element createModelTiePointsElement() {
        Element field = this.createFieldElement(GeoTIFFMetadata.getModelTiePointTag());
        Element data = new Element(IIO_TIFF_DOUBLES_ELEMENT_NAME);
        field.addContent((Content)data);
        for (TiePoint tiePoint : this._modelTiePoints) {
            this.addDoubleElements(data, tiePoint.data);
        }
        return field;
    }

    private Element createFieldElement(TIFFTag tag) {
        Element field = new Element(IIO_TIFF_FIELD_ELEMENT_NAME);
        field.setAttribute(IIO_TIFF_NUMBER_ATT_NAME, String.valueOf(tag.getNumber()));
        field.setAttribute(IIO_TIFF_NAME_ATT_NAME, tag.getName());
        return field;
    }

    private Element createShortElement(int value) {
        Element keyEntry = new Element(IIO_TIFF_SHORT_ELEMENT_NAME);
        keyEntry.setAttribute(IIO_TIFF_VALUE_ATT_NAME, String.valueOf(value));
        return keyEntry;
    }

    private Element createDoubleElement(double value) {
        Element param = new Element(IIO_TIFF_DOUBLE_ELEMENT_NAME);
        param.setAttribute(IIO_TIFF_VALUE_ATT_NAME, String.valueOf(value));
        return param;
    }

    private Element createAsciiElement(String value) {
        Element param = new Element(IIO_TIFF_ASCII_ELEMENT_NAME);
        param.setAttribute(IIO_TIFF_VALUE_ATT_NAME, String.valueOf(value));
        return param;
    }

    private void addDoubleElements(Element data, double[] values) {
        for (double value : values) {
            Element keyEntry = this.createDoubleElement(value);
            data.addContent((Content)keyEntry);
        }
    }

    public static class TiePoint {
        private double[] data = new double[6];

        private TiePoint(double i, double j, double k, double x, double y, double z) {
            this.set(i, j, k, x, y, z);
        }

        private void set(double i, double j, double k, double x, double y, double z) {
            this.data[0] = i;
            this.data[1] = j;
            this.data[2] = k;
            this.data[3] = x;
            this.data[4] = y;
            this.data[5] = z;
        }

        public double[] getData() {
            return this.data;
        }
    }

    public static class KeyEntry {
        private int[] data = new int[4];

        private KeyEntry(int keyID, int tag, int count, int offset) {
            this.set(keyID, tag, count, offset);
        }

        private void set(int keyID, int tag, int count, int offset) {
            this.data[0] = keyID;
            this.data[1] = tag;
            this.data[2] = count;
            this.data[3] = offset;
        }

        public int[] getData() {
            return this.data;
        }
    }
}

