/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.grid.isin;

import org.esa.snap.core.util.grid.isin.IsinPoint;
import org.esa.snap.core.util.grid.isin.IsinRow;

class IsinInverse {
    private static final long NZONE_MAX = 1296000L;
    double false_east;
    double false_north;
    double sphere;
    double sphere_inv;
    double ang_size_inv;
    long nrow;
    long nrow_half;
    double lon_cen_mer;
    double ref_lon;
    double col_dist;
    double col_dist_inv;
    int ijustify;
    IsinRow[] row;

    IsinInverse() {
    }

    void init(double radius, double centerLon, double falseEasting, double falseNorth, double dzone, double djustify) {
        if (radius <= 1.0E-10) {
            throw new IllegalArgumentException("bad parameter; sphere radius invalid");
        }
        if (centerLon < Math.PI * -2 || centerLon > Math.PI * 2) {
            throw new IllegalArgumentException("bad parameter; longitude of central meridian invalid");
        }
        if (dzone < 1.99 || dzone > 1296000.01) {
            throw new IllegalArgumentException("bad parameter; nzone out of range");
        }
        long nzone = (long)(dzone + 0.01);
        if (Math.abs(dzone - (double)nzone) > 0.01) {
            throw new IllegalArgumentException("bad parameter; nzone not near an integer value");
        }
        if (nzone % 2L != 0L) {
            throw new IllegalArgumentException("bad parameter; nzone not multiple of two");
        }
        if (djustify < -0.01 || djustify > 2.01) {
            throw new IllegalArgumentException("bad parameter; djustify out of range");
        }
        int ijustify = (int)(djustify + 0.01);
        if (Math.abs(djustify - (double)ijustify) > 0.01) {
            throw new IllegalArgumentException("bad parameter; ijustify not near an integer value");
        }
        double lon_cen_mer = centerLon;
        if (lon_cen_mer < -Math.PI) {
            lon_cen_mer += Math.PI * 2;
        } else if (lon_cen_mer > Math.PI) {
            lon_cen_mer -= Math.PI * 2;
        }
        this.false_east = falseEasting;
        this.false_north = falseNorth;
        this.sphere = radius;
        this.sphere_inv = 1.0 / radius;
        this.ang_size_inv = (double)nzone / Math.PI;
        this.nrow = nzone;
        this.nrow_half = nzone / 2L;
        this.lon_cen_mer = lon_cen_mer;
        this.ref_lon = lon_cen_mer - Math.PI;
        if (this.ref_lon < -Math.PI) {
            this.ref_lon += Math.PI * 2;
        }
        this.ijustify = ijustify;
        this.row = new IsinRow[(int)this.nrow_half];
        int irow = 0;
        while ((long)irow < this.nrow_half) {
            IsinRow currentRow = new IsinRow();
            double clat = 1.5707963267948966 * (1.0 - ((double)irow + 0.5) / (double)this.nrow_half);
            if (ijustify < 2) {
                currentRow.ncol = (long)(2.0 * Math.cos(clat) * (double)this.nrow + 0.5);
            } else {
                currentRow.ncol = (long)(Math.cos(clat) * (double)this.nrow + 0.5);
                currentRow.ncol *= 2L;
            }
            if (currentRow.ncol < 1L) {
                currentRow.ncol = 1L;
            }
            currentRow.ncol_inv = 1.0 / (double)currentRow.ncol;
            currentRow.icol_cen = ijustify == 1 ? (currentRow.ncol + 1L) / 2L : currentRow.ncol / 2L;
            this.row[irow] = currentRow;
            ++irow;
        }
        long ncol_cen = this.row[(int)(this.nrow_half - 1L)].ncol;
        this.col_dist = Math.PI * 2 * this.sphere / (double)ncol_cen;
        this.col_dist_inv = (double)ncol_cen / (Math.PI * 2 * this.sphere);
    }

    IsinPoint transform(IsinPoint point) {
        long irow;
        double x = point.getX();
        double y = point.getY();
        double lat = (y - this.false_north) * this.sphere_inv;
        if (lat < -1.5707963267948966 || lat > 1.5707963267948966) {
            lat = Double.NaN;
        }
        if ((irow = (long)((int)((1.5707963267948966 - lat) * this.ang_size_inv))) >= this.nrow_half) {
            irow = this.nrow - 1L - irow;
        }
        if (irow < 0L) {
            irow = 0L;
        }
        double col = (x - this.false_east) * this.col_dist_inv;
        int nrow = (int)irow;
        double flon = (col + (double)this.row[nrow].icol_cen) * this.row[nrow].ncol_inv;
        if (flon < 0.0 || flon > 1.0) {
            return new IsinPoint(Double.NaN, Double.NaN);
        }
        double lon = this.ref_lon + flon * (Math.PI * 2);
        if (lon >= Math.PI) {
            lon -= Math.PI * 2;
        }
        if (lon < -Math.PI) {
            lon += Math.PI * 2;
        }
        return new IsinPoint(lon, lat);
    }
}

