/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.grid.isin;

import org.esa.snap.core.util.grid.isin.ProjectionParam;
import org.esa.snap.core.util.grid.isin.ProjectionType;

class ProjectionParamFactory {
    ProjectionParamFactory() {
    }

    static ProjectionParam get(ProjectionType projectionType) {
        ProjectionParam projectionParam = new ProjectionParam();
        switch (projectionType) {
            case ISIN_K: {
                projectionParam.projection = ProjectionType.ISIN_K;
                break;
            }
            case ISIN_H: {
                projectionParam.projection = ProjectionType.ISIN_H;
                break;
            }
            case ISIN_Q: {
                projectionParam.projection = ProjectionType.ISIN_Q;
            }
        }
        ProjectionParamFactory.setIsinValues(projectionParam);
        return projectionParam;
    }

    private static void setIsinValues(ProjectionParam projectionParam) {
        projectionParam.iproj_tile = 1;
        projectionParam.ul_xul = -2.0015109354E7;
        projectionParam.ul_yul = 1.0007554677E7;
        projectionParam.pixel_size = 926.62543305;
        projectionParam.sphere_code = -1;
        projectionParam.sphere = 6371007.181;
        projectionParam.nl_tile = 1200;
        projectionParam.ns_tile = 1200;
        projectionParam.ntile_line = 18;
        projectionParam.ntile_samp = 36;
        projectionParam.nl_grid = 21600;
        projectionParam.ns_grid = 43200;
        projectionParam.nl_global = new int[]{90, 540, 1080, 4320};
        projectionParam.ns_global = new int[]{180, 1080, 2160, 8640};
        projectionParam.nl_offset = new int[]{0, 0, 0, 0};
        projectionParam.ns_offset = new int[]{0, 0, 0, 0};
    }
}

