/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.esa.snap.core.util.io.InputStreamObserver;

public class ObservableInputStream
extends FilterInputStream {
    private InputStreamObserver observer;
    private long numBytesRead;
    private long numBytesTotal;

    public ObservableInputStream(InputStream in, InputStreamObserver listener) {
        super(in);
        try {
            this.numBytesTotal = in.available();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.observer = listener;
    }

    public ObservableInputStream(InputStream in, long size, InputStreamObserver listener) {
        super(in);
        this.numBytesTotal = size;
        this.observer = listener;
    }

    public long getNumBytesTotal() {
        return this.numBytesTotal;
    }

    public long getNumBytesRead() {
        return this.numBytesRead;
    }

    public InputStreamObserver getObserver() {
        return this.observer;
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            this.fireProgress(1L);
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        if (nr > 0) {
            this.fireProgress(nr);
        }
        return nr;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this.fireProgress(nr);
        }
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.fireProgress(nr);
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        if (this.numBytesRead != this.numBytesTotal) {
            this.observer.onReadEnded();
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.fireProgress(this.numBytesTotal - (long)this.in.available() - this.numBytesRead);
    }

    private void fireProgress(long delta) throws IOException {
        if (this.numBytesRead == 0L) {
            this.observer.onReadStarted(this.numBytesTotal);
        }
        this.numBytesRead += delta;
        this.observer.onReadProgress(this.numBytesRead);
        if (this.numBytesRead == this.numBytesTotal) {
            this.observer.onReadEnded();
        }
        if (this.observer.isReadingCanceled()) {
            InterruptedIOException exc = new InterruptedIOException("Reading has been interrupted.");
            exc.bytesTransferred = (int)this.numBytesRead;
            throw exc;
        }
    }
}

