/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.io;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.EnumSet;

public class TreeCopier
implements FileVisitor<Path> {
    private final Path source;
    private final Path target;
    private IOException exception;

    public static Path copyDir(Path source, Path targetParent) throws IOException {
        Path target = targetParent.resolve(source.getFileName().toString());
        if (!Files.exists(target, new LinkOption[0])) {
            target = Files.createDirectory(target, new FileAttribute[0]);
        }
        TreeCopier.copy(source, target);
        return target;
    }

    public static void copy(Path source, Path target) throws IOException {
        if (!Files.exists(target, new LinkOption[0])) {
            throw new NoSuchFileException(target.toString());
        }
        if (!Files.isDirectory(target, new LinkOption[0])) {
            throw new NotDirectoryException(target.toString());
        }
        TreeCopier treeCopier = new TreeCopier(source, target);
        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, treeCopier);
        if (treeCopier.exception != null) {
            throw treeCopier.exception;
        }
    }

    TreeCopier(Path source, Path target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
        Files.copy(file, this.target.resolve(this.source.relativize(file).toString()), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attributes) throws IOException {
        try {
            Files.copy(dir, this.target.resolve(this.source.relativize(dir).toString()), StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exception) throws IOException {
        if (exception == null) {
            Path newDir = this.target.resolve(this.source.relativize(dir).toString());
            FileTime time = Files.getLastModifiedTime(dir, new LinkOption[0]);
            Files.setLastModifiedTime(newDir, time);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exception) {
        this.exception = exception;
        return FileVisitResult.TERMINATE;
    }
}

