/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.io;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

public class TreeDeleter
implements FileVisitor<Path> {
    private IOException exception;

    public static void deleteDir(Path source) throws IOException {
        TreeDeleter treeDeleter = new TreeDeleter();
        Files.walkFileTree(source, treeDeleter);
        if (treeDeleter.exception != null) {
            throw treeDeleter.exception;
        }
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
        Files.delete(file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attributes) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exception) throws IOException {
        if (exception == null) {
            Files.delete(dir);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exception) {
        this.exception = exception;
        return FileVisitResult.TERMINATE;
    }
}

