/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.io;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class WildcardMatcher {
    private final Pattern pattern;
    private final boolean windowsFs;

    public WildcardMatcher(String wildcard) {
        this(wildcard, WildcardMatcher.isWindowsOs());
    }

    WildcardMatcher(String wildcard, boolean windowsFs) {
        this.pattern = Pattern.compile(WildcardMatcher.wildcardToRegexp(wildcard.trim(), windowsFs));
        this.windowsFs = windowsFs;
    }

    boolean isWindowsFs() {
        return this.windowsFs;
    }

    public static File[] glob(String filePattern) throws IOException {
        TreeSet<File> fileSet = new TreeSet<File>();
        WildcardMatcher.glob(filePattern, fileSet);
        return fileSet.toArray(new File[fileSet.size()]);
    }

    public static void glob(String filePattern, Set<File> fileSet) throws IOException {
        File patternFile = new File(filePattern);
        if (patternFile.exists()) {
            fileSet.add(patternFile.getCanonicalFile());
            return;
        }
        boolean windowsOs = WildcardMatcher.isWindowsOs();
        String[] patternSplit = WildcardMatcher.splitBasePath(filePattern, windowsOs);
        String basePath = patternSplit[0];
        String patternPath = patternSplit[1];
        if (patternPath.isEmpty()) {
            return;
        }
        File canonicalBaseFile = new File(basePath).getCanonicalFile();
        String newpattern = canonicalBaseFile.getPath() + "/" + patternPath;
        WildcardMatcher matcher = new WildcardMatcher(newpattern);
        HashSet<File> visitedDirs = new HashSet<File>();
        WildcardMatcher.collectFiles(matcher, canonicalBaseFile, fileSet, visitedDirs);
    }

    private static void collectFiles(WildcardMatcher matcher, File dir, Set<File> fileSet, Set<File> visitedDirs) throws IOException {
        if (visitedDirs.contains(dir.getCanonicalFile())) {
            return;
        }
        visitedDirs.add(dir.getCanonicalFile());
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException(String.format("Failed to access directory '%s'", dir));
        }
        for (File file : files) {
            if (matcher.matches(file.getCanonicalPath()) || matcher.matches(file.getPath())) {
                fileSet.add(file.getCanonicalFile());
            }
            if (!file.isDirectory()) continue;
            WildcardMatcher.collectFiles(matcher, file, fileSet, visitedDirs);
        }
    }

    static String[] splitBasePath(String filePattern, boolean iswindows) {
        if (iswindows) {
            filePattern = filePattern.replace("\\", "/");
        }
        String basePath = filePattern.startsWith("/") ? "/" : "";
        String[] parts = filePattern.split("/");
        int firstPatternIndex = 0;
        for (int i = 0; i < parts.length && !WildcardMatcher.containsWildcardChar(parts[i]); ++i) {
            if (parts[i].isEmpty()) continue;
            basePath = basePath + parts[i];
            if (i < parts.length - 1) {
                basePath = basePath + "/";
            }
            firstPatternIndex = i + 1;
        }
        String patterPath = "";
        for (int i = firstPatternIndex; i < parts.length; ++i) {
            patterPath = patterPath + parts[i];
            if (i >= parts.length - 1) continue;
            patterPath = patterPath + "/";
        }
        return new String[]{basePath, patterPath};
    }

    private static boolean containsWildcardChar(String part) {
        return part.equals("**") || part.contains("*") || part.contains("?");
    }

    String getRegex() {
        return this.pattern.pattern();
    }

    static String wildcardToRegexp(String wildcard, boolean windowsFs) {
        String[] metas;
        String s = WildcardMatcher.resolvePath(wildcard, windowsFs);
        s = s.replace("/**/", "_%SLASHSTARSTARSLASH%_");
        s = s.replace("/**", "_%SLASHSTARSTAR%_");
        s = s.replace("**/", "_%STARSTARSLASH%_");
        s = s.replace("*", "_%STAR%_");
        s = s.replace("?", "_%QUOTE%_");
        for (String meta : metas = new String[]{"\\", "|", "^", "$", "+", ".", "(", ")", "{", "}", "<", ">"}) {
            s = s.replace(meta, "\\" + meta);
        }
        s = s.replace("_%SLASHSTARSTARSLASH%_", "((/.*/)?|/)");
        s = s.replace("_%SLASHSTARSTAR%_", "(/.*)?");
        s = s.replace("_%STARSTARSLASH%_", "(.*/)?");
        s = s.replace("_%STAR%_", "[^/:]*");
        s = s.replace("_%QUOTE%_", ".");
        return s;
    }

    public boolean matches(String text) {
        return this.pattern.matcher(WildcardMatcher.resolvePath(text, this.windowsFs)).matches();
    }

    private static boolean isWindowsOs() {
        return System.getProperty("os.name").contains("Win");
    }

    private static String resolvePath(String text, boolean windowsFs) {
        if (windowsFs) {
            text = text.toLowerCase().replace("\\", "/");
        }
        while (text.startsWith("./")) {
            text = text.substring(2);
        }
        return text;
    }
}

