/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.jai;

import com.sun.media.jai.util.CacheDiagnostics;
import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Comparator;
import javax.media.jai.TileCache;

@Deprecated
public class VerbousTileCache
implements TileCache {
    private final TileCache tileCache;
    private CacheDiagnostics cacheDiagnostics;
    String indent = "";
    static boolean verbous;

    public static boolean isVerbous() {
        return verbous;
    }

    public static void setVerbous(boolean verbous) {
        VerbousTileCache.verbous = verbous;
    }

    public VerbousTileCache(TileCache tileCache) {
        this.tileCache = tileCache;
        if (tileCache instanceof CacheDiagnostics) {
            this.cacheDiagnostics = (CacheDiagnostics)tileCache;
            this.cacheDiagnostics.enableDiagnostics();
        }
    }

    public void add(RenderedImage renderedImage, int tileX, int tileY, Raster tile) {
        this.tileCache.add(renderedImage, tileX, tileY, tile);
        this.trace("add", renderedImage, tile, VerbousTileCache.getTilePos(tileX, tileY));
    }

    public void add(RenderedImage renderedImage, int tileX, int tileY, Raster tile, Object o) {
        this.tileCache.add(renderedImage, tileX, tileY, tile, o);
        this.trace("add-2", renderedImage, tile, VerbousTileCache.getTilePos(tileX, tileY));
    }

    public void remove(RenderedImage renderedImage, int tileX, int tileY) {
        this.tileCache.remove(renderedImage, tileX, tileY);
        this.trace("remove", renderedImage, null, VerbousTileCache.getTilePos(tileX, tileY));
    }

    public Raster getTile(RenderedImage renderedImage, int tileX, int tileY) {
        Raster tile = this.tileCache.getTile(renderedImage, tileX, tileY);
        this.trace("getTile", renderedImage, tile, VerbousTileCache.getTilePos(tileX, tileY));
        return tile;
    }

    private static String getTilePos(int tileX, int tileY) {
        return "(" + tileX + "," + tileY + ")";
    }

    public Raster[] getTiles(RenderedImage renderedImage) {
        Raster[] tiles = this.tileCache.getTiles(renderedImage);
        this.trace("getTiles", renderedImage, null, "n.a.");
        return tiles;
    }

    public void removeTiles(RenderedImage renderedImage) {
        this.tileCache.removeTiles(renderedImage);
        this.trace("removeTiles", renderedImage, null, "n.a.");
    }

    public void addTiles(RenderedImage renderedImage, Point[] points, Raster[] rasters, Object o) {
        this.tileCache.addTiles(renderedImage, points, rasters, o);
        this.trace("addTiles", renderedImage, null, "n.a.");
    }

    public Raster[] getTiles(RenderedImage renderedImage, Point[] points) {
        Raster[] tiles = this.tileCache.getTiles(renderedImage, points);
        this.trace("getTiles", renderedImage, null, "n.a.");
        return tiles;
    }

    public void flush() {
        this.trace("flush (start)", null, null, "n.a.");
        this.tileCache.flush();
        this.trace("flush (end)", null, null, "n.a.");
    }

    public void memoryControl() {
        this.trace("memoryControl (start)", null, null, "n.a.");
        this.tileCache.memoryControl();
        this.trace("memoryControl (end)", null, null, "n.a.");
    }

    public void setTileCapacity(int i) {
        this.tileCache.setTileCapacity(i);
    }

    public int getTileCapacity() {
        return this.tileCache.getTileCapacity();
    }

    public void setMemoryCapacity(long l) {
        this.tileCache.setMemoryCapacity(l);
    }

    public long getMemoryCapacity() {
        return this.tileCache.getMemoryCapacity();
    }

    public void setMemoryThreshold(float v) {
        this.tileCache.setMemoryThreshold(v);
    }

    public float getMemoryThreshold() {
        return this.tileCache.getMemoryThreshold();
    }

    public void setTileComparator(Comparator comparator) {
        this.tileCache.setTileComparator(comparator);
    }

    public Comparator getTileComparator() {
        return this.tileCache.getTileComparator();
    }

    private void trace(String method, RenderedImage image, Raster tile, String tilePos) {
        if (verbous) {
            this.println("JAI TileCache Diagnostics: ======================================");
            this.println("  cache   = " + this.tileCache);
            this.println("  method  = " + method);
            this.println("  image   = " + image);
            this.println("  tilePos = " + tilePos);
            String tileString = "  tile    = " + tile;
            String dimString = "";
            if (tile != null) {
                dimString = " [width = " + tile.getWidth() + " height = " + tile.getHeight() + "]";
            }
            this.println(tileString + dimString);
            if (this.cacheDiagnostics != null) {
                this.println("  cacheTileCount  = " + this.cacheDiagnostics.getCacheTileCount());
                this.println("  cacheHitCount   = " + this.cacheDiagnostics.getCacheHitCount());
                this.println("  cacheMissCount  = " + this.cacheDiagnostics.getCacheMissCount());
                this.println("  cacheMemoryUsed = " + this.cacheDiagnostics.getCacheMemoryUsed());
            }
        } else {
            this.println(method + " : " + tilePos + " " + image);
        }
    }

    private void println(String x) {
    }
}

