/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.math;

import org.esa.snap.core.util.math.DistanceMeasure;

public class EuclideanDistance
implements DistanceMeasure {
    private final double lon0;
    private final double lat0;

    public EuclideanDistance(double lon0, double lat0) {
        this.lon0 = lon0;
        this.lat0 = lat0;
    }

    @Override
    public double distance(double lon, double lat) {
        double deltaLat = lat - this.lat0;
        double deltaLon = lon - this.lon0;
        if (deltaLon < 0.0) {
            deltaLon = -deltaLon;
        }
        if (deltaLon > 180.0) {
            deltaLon = 360.0 - deltaLon;
        }
        return deltaLat * deltaLat + deltaLon * deltaLon;
    }
}

