/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.math;

import Jama.Matrix;
import org.esa.snap.core.util.math.ConstrainedLSU;
import org.esa.snap.core.util.math.LinearAlgebra;
import org.esa.snap.core.util.math.SpectralUnmixing;

public class FullyConstrainedLSU
implements SpectralUnmixing {
    private final int nchem;
    private final int nmemb;
    private final SpectralUnmixing[][] trialModels;
    private final boolean[][][] sortedemcombs;

    public FullyConstrainedLSU(double[][] endmembers) {
        int p;
        int nc;
        int nem;
        if (!LinearAlgebra.isMatrix(endmembers)) {
            throw new IllegalArgumentException("Parameter 'endmembers' is not a matrix.");
        }
        this.nchem = endmembers.length;
        this.nmemb = endmembers[0].length;
        int nposs = (1 << this.nmemb) - 1;
        int[] rb = new int[nposs];
        for (int i = 0; i < nposs; ++i) {
            rb[i] = i + 1;
        }
        boolean[][] emcombs = new boolean[nposs][this.nmemb];
        for (int k = 0; k < nposs; ++k) {
            int zpot = 1;
            for (int l = 0; l < this.nmemb; ++l) {
                int h = zpot & rb[k];
                emcombs[k][l] = h > 0;
                zpot *= 2;
            }
        }
        int[] numbin = new int[nposs];
        for (int k = 0; k < nposs; ++k) {
            numbin[k] = FullyConstrainedLSU.countTrue(emcombs[k]);
        }
        this.sortedemcombs = new boolean[this.nmemb][][];
        this.trialModels = new ConstrainedLSU[this.nmemb][];
        for (nem = this.nmemb - 1; nem >= 0; --nem) {
            nc = 0;
            for (p = 0; p < nposs; ++p) {
                if (nem + 1 != numbin[p]) continue;
                ++nc;
            }
            this.sortedemcombs[this.nmemb - nem - 1] = new boolean[nc][this.nmemb];
            this.trialModels[this.nmemb - nem - 1] = new ConstrainedLSU[nc];
        }
        for (nem = this.nmemb - 1; nem >= 0; --nem) {
            nc = 0;
            for (p = 0; p < nposs; ++p) {
                if (nem + 1 != numbin[p]) continue;
                System.arraycopy(emcombs[p], 0, this.sortedemcombs[this.nmemb - nem - 1][nc], 0, this.nmemb);
                double[][] trem = FullyConstrainedLSU.extractColumns(endmembers, this.sortedemcombs[this.nmemb - nem - 1][nc]);
                this.trialModels[this.nmemb - nem - 1][nc] = new ConstrainedLSU(trem);
                ++nc;
            }
        }
    }

    @Override
    public double[][] unmix(double[][] spectra) {
        int colCount = spectra[0].length;
        Matrix res = new Matrix(this.nmemb, colCount);
        for (int nspek = 0; nspek < colCount; ++nspek) {
            double[][] singlesp = FullyConstrainedLSU.extractSingleColum(spectra, nspek);
            double totalerrbest = 1.0E21;
            for (int nc = 0; nc < this.nmemb; ++nc) {
                boolean foundlegal = false;
                int nmods = this.trialModels[nc].length;
                boolean[] allabupos = new boolean[nmods];
                double[][][] abuc = new double[nmods][][];
                for (int m = 0; m < nmods; ++m) {
                    allabupos[m] = true;
                }
                double[] err = new double[nmods];
                for (int m = 0; m < nmods; ++m) {
                    abuc[m] = this.trialModels[nc][m].unmix(singlesp);
                    for (int k = 0; k < abuc[m].length; ++k) {
                        if (!(abuc[m][k][0] < 0.0)) continue;
                        allabupos[m] = false;
                    }
                    if (!allabupos[m]) continue;
                    foundlegal = true;
                    double[][] rspek = this.trialModels[nc][m].mix(abuc[m]);
                    double sum = 0.0;
                    for (int k = 0; k < this.nchem; ++k) {
                        double diff = singlesp[k][0] - rspek[k][0];
                        sum += diff * diff;
                    }
                    err[m] = sum;
                }
                if (!foundlegal) continue;
                int mbest = -1;
                double errbest = Double.POSITIVE_INFINITY;
                for (int m = 0; m < nmods; ++m) {
                    if (!allabupos[m] || !(err[m] < errbest)) continue;
                    errbest = err[m];
                    mbest = m;
                }
                if (mbest == -1) continue;
                double[][] abucd = abuc[mbest];
                double[][] abu = new double[this.nmemb][1];
                int take = 0;
                for (int k = 0; k < this.nmemb; ++k) {
                    if (!this.sortedemcombs[nc][mbest][k]) continue;
                    abu[k][0] = abucd[take][0];
                    ++take;
                }
                if (!(errbest < totalerrbest)) continue;
                res.setMatrix(0, this.nmemb - 1, nspek, nspek, new Matrix(abu));
                totalerrbest = errbest;
            }
        }
        return res.getArrayCopy();
    }

    @Override
    public double[][] mix(double[][] abundances) {
        return this.trialModels[0][0].mix(abundances);
    }

    private static double[][] extractColumns(double[][] a, boolean[] columns) {
        int rowCount = a.length;
        int colCount = a[0].length;
        int hm = 0;
        for (boolean column : columns) {
            if (!column) continue;
            ++hm;
        }
        double[][] c = new double[rowCount][hm];
        int k = 0;
        for (int j = 0; j < colCount; ++j) {
            if (!columns[j]) continue;
            for (int i = 0; i < rowCount; ++i) {
                c[i][k] = a[i][j];
            }
            ++k;
        }
        return c;
    }

    private static double[][] extractSingleColum(double[][] a, int j) {
        double[][] c = new double[a.length][1];
        for (int i = 0; i < a.length; ++i) {
            c[i][0] = a[i][j];
        }
        return c;
    }

    private static int countTrue(boolean[] combs) {
        int count = 0;
        for (boolean comb : combs) {
            if (!comb) continue;
            ++count;
        }
        return count;
    }
}

