/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.math;

import org.esa.snap.core.util.math.Array;
import org.esa.snap.core.util.math.FracIndex;
import org.esa.snap.core.util.math.IntervalPartition;
import org.esa.snap.core.util.math.LookupTable;

public class VectorLookupTable {
    private final Array values;
    private final IntervalPartition[] dimensions;
    private final int[] strides;
    private final int[] o;
    private final int vectorLength;

    public VectorLookupTable(int length, double[] values, IntervalPartition ... dimensions) {
        this(length, new Array.Double(values), dimensions);
    }

    public VectorLookupTable(int length, float[] values, IntervalPartition ... dimensions) {
        this(length, new Array.Float(values), dimensions);
    }

    public VectorLookupTable(int length, double[] values, double[] ... dimensions) {
        this(length, values, IntervalPartition.createArray(dimensions));
    }

    public VectorLookupTable(int length, float[] values, float[] ... dimensions) {
        this(length, values, IntervalPartition.createArray(dimensions));
    }

    VectorLookupTable(int length, Array values, IntervalPartition ... dimensions) {
        if (length < 1) {
            throw new IllegalArgumentException("length < 1");
        }
        this.vectorLength = length;
        LookupTable.ensureLegalArray(dimensions);
        LookupTable.ensureLegalArray(values, this.vectorLength * LookupTable.getVertexCount(dimensions));
        this.values = values;
        this.dimensions = dimensions;
        int n = dimensions.length;
        this.strides = new int[n];
        int i = n;
        int stride = this.vectorLength;
        while (i-- > 0) {
            this.strides[i] = stride;
            stride *= dimensions[i].getCardinal();
        }
        this.o = new int[1 << n];
        LookupTable.computeVertexOffsets(this.strides, this.o);
    }

    public final int getDimensionCount() {
        return this.dimensions.length;
    }

    public final IntervalPartition[] getDimensions() {
        return this.dimensions;
    }

    public final IntervalPartition getDimension(int i) {
        return this.dimensions[i];
    }

    public final double[] getValues(double ... coordinates) throws IllegalArgumentException {
        LookupTable.ensureLegalArray(coordinates, this.dimensions.length);
        FracIndex[] fracIndices = FracIndex.createArray(this.dimensions.length);
        for (int i = 0; i < this.dimensions.length; ++i) {
            LookupTable.computeFracIndex(this.dimensions[i], coordinates[i], fracIndices[i]);
        }
        return this.getValues(fracIndices);
    }

    private double[] getValues(FracIndex ... fracIndexes) {
        int i;
        int origin = 0;
        for (int i2 = 0; i2 < this.dimensions.length; ++i2) {
            origin += fracIndexes[i2].i * this.strides[i2];
        }
        double[][] outValues = new double[1 << this.dimensions.length][this.vectorLength];
        for (i = 0; i < outValues.length; ++i) {
            this.values.copyTo(origin + this.o[i], outValues[i], 0, outValues[i].length);
        }
        i = this.dimensions.length;
        while (i-- > 0) {
            int m = 1 << i;
            double f = fracIndexes[i].f;
            for (int j = 0; j < m; ++j) {
                for (int k = 0; k < outValues[j].length; ++k) {
                    double[] dArray = outValues[j];
                    int n = k;
                    dArray[n] = dArray[n] + f * (outValues[m + j][k] - outValues[j][k]);
                }
            }
        }
        return outValues[0];
    }
}

