/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio;

import com.sun.media.imageio.stream.FileChannelImageInputStream;
import com.sun.media.imageioimpl.stream.ChannelImageInputStreamSpi;
import java.io.File;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;

public class FileImageInputStreamSpi
extends ChannelImageInputStreamSpi {
    public ImageInputStream createInputStreamInstance(Object input, boolean useCache, File cacheDir) throws IOException {
        if (!File.class.isInstance(input)) {
            throw new IllegalArgumentException("This SPI accepts only java.io.File");
        }
        File inputFile = (File)input;
        final FileChannel channel = FileChannel.open(inputFile.toPath(), StandardOpenOption.READ);
        if (useCache) {
            return new FileCacheImageInputStream(Channels.newInputStream(channel), cacheDir){

                @Override
                public void close() throws IOException {
                    channel.close();
                    super.close();
                }
            };
        }
        return new FileChannelImageInputStream(channel){

            public void close() throws IOException {
                channel.close();
                super.close();
            }
        };
    }

    public Class<?> getInputClass() {
        return File.class;
    }
}

