/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio;

import java.io.File;
import java.util.Iterator;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageInputStreamSpi;
import org.esa.snap.dataio.FileImageInputStreamSpi;

public class ImageRegistryUtils {
    private ImageRegistryUtils() {
    }

    public static void deregisterImageInputStreamSpi(ImageInputStreamSpi imageInputStreamSpi) {
        if (imageInputStreamSpi == null) {
            throw new NullPointerException("The image spi is null.");
        }
        IIORegistry.getDefaultInstance().deregisterServiceProvider(imageInputStreamSpi);
    }

    public static synchronized FileImageInputStreamSpi registerImageInputStreamSpi() {
        IIORegistry defaultInstance = IIORegistry.getDefaultInstance();
        FileImageInputStreamSpi imageInputStreamSpi = defaultInstance.getServiceProviderByClass(FileImageInputStreamSpi.class);
        if (imageInputStreamSpi == null) {
            ImageInputStreamSpi toUnorder = null;
            Iterator<ImageInputStreamSpi> serviceProviders = defaultInstance.getServiceProviders(ImageInputStreamSpi.class, true);
            while (serviceProviders.hasNext()) {
                ImageInputStreamSpi current = serviceProviders.next();
                if (current.getInputClass() != File.class) continue;
                toUnorder = current;
                break;
            }
            imageInputStreamSpi = new FileImageInputStreamSpi();
            defaultInstance.registerServiceProvider((Object)imageInputStreamSpi);
            if (toUnorder != null) {
                defaultInstance.setOrdering(ImageInputStreamSpi.class, imageInputStreamSpi, toUnorder);
            }
        }
        return imageInputStreamSpi;
    }
}

