/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wms.request;

import java.awt.Dimension;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.StyleImpl;
import org.geotools.data.wms.request.AbstractWMSRequest;
import org.geotools.data.wms.request.GetMapRequest;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.util.logging.Logging;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractGetMapRequest
extends AbstractWMSRequest
implements GetMapRequest {
    Stack layers = new Stack();
    Stack styles = new Stack();
    static final Logger LOGGER = Logging.getLogger(AbstractGetMapRequest.class);

    public AbstractGetMapRequest(URL onlineResource, Properties properties) {
        super(onlineResource, properties);
    }

    @Override
    public URL getFinalURL() {
        if (!this.layers.isEmpty()) {
            String layerString = "";
            String styleString = "";
            ListIterator layerIter = this.layers.listIterator(this.layers.size());
            ListIterator styleIter = this.styles.listIterator(this.styles.size());
            while (layerIter.hasPrevious()) {
                String layerName = (String)layerIter.previous();
                String styleName = (String)styleIter.previous();
                try {
                    layerString = layerString + URLEncoder.encode(layerName, "UTF-8").replaceAll("\\+", "%20");
                }
                catch (UnsupportedEncodingException | NullPointerException e) {
                    layerString = layerString + layerName;
                }
                styleName = styleName == null ? "" : styleName;
                try {
                    styleString = styleString + URLEncoder.encode(styleName, "UTF-8").replaceAll("\\+", "%20");
                }
                catch (UnsupportedEncodingException | NullPointerException e1) {
                    styleString = styleString + styleName;
                }
                if (!layerIter.hasPrevious()) continue;
                layerString = layerString + ",";
                styleString = styleString + ",";
            }
            this.setProperty("LAYERS", layerString);
            this.setProperty("STYLES", styleString);
        }
        return super.getFinalURL();
    }

    @Override
    protected abstract void initVersion();

    @Override
    protected void initRequest() {
        this.setProperty("REQUEST", "GetMap");
    }

    @Override
    public void setVersion(String version) {
        this.properties.setProperty("VERSION", version);
    }

    @Override
    public void addLayer(Layer layer, String style) {
        this.addLayer(layer.getName(), style);
    }

    @Override
    public void addLayer(Layer layer) {
        this.addLayer(layer, "");
    }

    @Override
    public void addLayer(String layerName, String style) {
        this.layers.push(layerName);
        if (style == null) {
            style = "";
        }
        this.styles.push(style);
    }

    @Override
    public void addLayer(Layer layer, StyleImpl style) {
        if (style == null) {
            this.addLayer(layer.getName(), "");
            return;
        }
        this.addLayer(layer.getName(), style.getName());
    }

    @Override
    public void addLayer(String layerName, StyleImpl style) {
        if (style == null) {
            this.addLayer(layerName, "");
            return;
        }
        this.addLayer(layerName, style.getName());
    }

    @Override
    public void setSRS(String srs) {
        this.properties.setProperty("SRS", srs);
    }

    @Override
    public void setBBox(String bbox) {
        bbox = bbox.replace(" ", "");
        this.properties.setProperty("BBOX", bbox);
    }

    public static CoordinateReferenceSystem toServerCRS(String srsName, boolean forceXY) {
        try {
            if (srsName != null) {
                if (forceXY) {
                    CoordinateReferenceSystem crs = CRS.decode((String)srsName, (boolean)true);
                    if (CRS.getAxisOrder((CoordinateReferenceSystem)crs) == CRS.AxisOrder.NORTH_EAST) {
                        Integer epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
                        if (epsgCode == null) {
                            throw new IllegalArgumentException("Could not find EPSG code for " + srsName);
                        }
                        return CRS.decode((String)("EPSG:" + epsgCode), (boolean)true);
                    }
                    return crs;
                }
                if (srsName.startsWith("EPSG:") && AbstractGetMapRequest.isGeotoolsLongitudeFirstAxisOrderForced()) {
                    String explicit = srsName.replace("EPSG:", "urn:x-ogc:def:crs:EPSG::");
                    return CRS.decode((String)explicit, (boolean)false);
                }
                return CRS.decode((String)srsName, (boolean)false);
            }
            return CRS.decode((String)"CRS:84");
        }
        catch (NoSuchAuthorityCodeException e) {
            LOGGER.log(Level.FINE, "Failed to build a coordiante reference system from " + srsName + " with forceXY " + forceXY, e);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.FINE, "Failed to build a coordiante reference system from " + srsName + " with forceXY " + forceXY, e);
        }
        return DefaultEngineeringCRS.CARTESIAN_2D;
    }

    protected static boolean isGeotoolsLongitudeFirstAxisOrderForced() {
        return Boolean.getBoolean("org.geotools.referencing.forceXY") || GeoTools.getDefaultHints().get((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER) == Boolean.TRUE;
    }

    @Override
    public void setBBox(Envelope envelope) {
        GeneralEnvelope bbox;
        String version = this.properties.getProperty("VERSION");
        boolean forceXY = version == null || !version.startsWith("1.3");
        String srsName = CRS.toSRS((CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem());
        CoordinateReferenceSystem crs = AbstractGetMapRequest.toServerCRS(srsName, forceXY);
        try {
            bbox = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)crs);
        }
        catch (TransformException e) {
            bbox = envelope;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(bbox.getMinimum(0));
        sb.append(",");
        sb.append(bbox.getMinimum(1) + ",");
        sb.append(bbox.getMaximum(0) + ",");
        sb.append(bbox.getMaximum(1));
        this.setBBox(sb.toString());
    }

    @Override
    public void setFormat(String format) {
        this.properties.setProperty("FORMAT", format);
    }

    @Override
    public void setDimensions(String width, String height) {
        this.properties.setProperty("HEIGHT", height);
        this.properties.setProperty("WIDTH", width);
    }

    @Override
    public void setDimensions(Dimension imageDimension) {
        this.setDimensions(imageDimension.width, imageDimension.height);
    }

    @Override
    public void setTransparent(boolean transparent) {
        String value = "FALSE";
        if (transparent) {
            value = "TRUE";
        }
        this.properties.setProperty("TRANSPARENT", value);
    }

    @Override
    public void setBGColour(String bgColour) {
        this.properties.setProperty("BGCOLOR", bgColour);
    }

    @Override
    public void setExceptions(String exceptions) {
        this.properties.setProperty("EXCEPTIONS", exceptions);
    }

    @Override
    public void setTime(String time) {
        this.properties.setProperty("TIME", time);
    }

    @Override
    public void setElevation(String elevation) {
        this.properties.setProperty("ELEVATION", elevation);
    }

    @Override
    public void setSampleDimensionValue(String name, String value) {
        this.properties.setProperty(name, value);
    }

    @Override
    public void setVendorSpecificParameter(String name, String value) {
        this.properties.setProperty(name, value);
    }

    @Override
    public void setDimensions(int width, int height) {
        this.setDimensions("" + width, "" + height);
    }

    @Override
    public void setProperties(Properties p) {
        this.properties = p;
    }
}

