/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.format.UnitFormat;
import org.geotools.measure.Units;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.opengis.metadata.citation.Citation;
import si.uom.NonSI;
import si.uom.SI;
import systems.uom.common.USCustomary;
import tec.uom.se.format.SimpleUnitFormat;

abstract class GeoToolsUnitFormat
extends SimpleUnitFormat {
    private static final ESRIFormat ESRI = new ESRIFormat();
    private static final EPSGFormat EPSG = new EPSGFormat();

    GeoToolsUnitFormat() {
    }

    public static UnitFormat getInstance(Citation citation) {
        if (CRS.equalsIgnoreMetadata(Citations.ESRI, citation)) {
            return ESRI;
        }
        return EPSG;
    }

    static class ESRIFormat
    extends BaseGT2Format {
        private static final long serialVersionUID = 5769662824845469523L;

        public ESRIFormat() {
            this.initUnits();
            ESRIFormat.esriLabelsAndAliases(this);
        }

        @Override
        protected void addUnit(Unit<?> unit) {
        }
    }

    static class EPSGFormat
    extends BaseGT2Format {
        private static final long serialVersionUID = -1207705344688824557L;

        public EPSGFormat() {
            this.initUnits();
            EPSGFormat.epsgLabelsAndAliases(this);
        }

        @Override
        protected void addUnit(Unit<?> unit) {
        }
    }

    static abstract class BaseGT2Format
    extends SimpleUnitFormat.DefaultFormat {
        BaseGT2Format() {
        }

        protected void initUnits() {
            SimpleUnitFormat.DefaultFormat base = (SimpleUnitFormat.DefaultFormat)Units.getDefaultFormat();
            try {
                Field nameToUnitField = SimpleUnitFormat.DefaultFormat.class.getDeclaredField("_nameToUnit");
                nameToUnitField.setAccessible(true);
                HashMap nameToUnitMap = (HashMap)nameToUnitField.get(base);
                Field unitToNameField = SimpleUnitFormat.DefaultFormat.class.getDeclaredField("_unitToName");
                unitToNameField.setAccessible(true);
                HashMap unitToNameMap = (HashMap)unitToNameField.get(base);
                for (Map.Entry entry : nameToUnitMap.entrySet()) {
                    String name = (String)entry.getKey();
                    Unit unit = (Unit)entry.getValue();
                    if (unitToNameMap.containsKey(unit) && name.equals(unitToNameMap.get(unit))) {
                        this.label(unit, name);
                        this.addUnit(unit);
                        continue;
                    }
                    this.alias(unit, name);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        protected static void esriLabelsAndAliases(BaseGT2Format format) {
            format.label(NonSI.DEGREE_ANGLE, "Degree");
            format.label(SI.METRE, "Meter");
            format.label(SI.METRE.multiply(0.3047997101815088), "Foot_Gold_Coast");
            format.label(USCustomary.FOOT, "Foot");
            format.label(USCustomary.FOOT_SURVEY, "Foot_US");
        }

        protected static void epsgLabelsAndAliases(BaseGT2Format format) {
            format.label(NonSI.DEGREE_ANGLE, "degree");
        }

        protected abstract void addUnit(Unit<?> var1);
    }
}

