/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf;

import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;

public class PartialDataCopier {
    public static void copy(int[] offset, Array source, Array target) throws InvalidRangeException {
        int[] sourceShape = source.getShape();
        int[] targetShape = target.getShape();
        ArrayList<Range> sourceRanges = new ArrayList<Range>();
        ArrayList<Range> targetRanges = new ArrayList<Range>();
        for (int dimension = 0; dimension < offset.length; ++dimension) {
            int targetFirst;
            int sourceFirst;
            int dimOffset = offset[dimension];
            if (dimOffset >= 0) {
                sourceFirst = dimOffset;
                targetFirst = 0;
            } else {
                sourceFirst = 0;
                targetFirst = dimOffset * -1;
            }
            int maxSSteps = sourceShape[dimension] - sourceFirst;
            int maxTSteps = targetShape[dimension] - targetFirst;
            int maxSteps = Math.min(maxSSteps, maxTSteps);
            int sourceLast = sourceFirst + maxSteps;
            int targetLast = targetFirst + maxSteps;
            sourceRanges.add(new Range(sourceFirst, sourceLast - 1));
            targetRanges.add(new Range(targetFirst, targetLast - 1));
        }
        IndexIterator sourceRangeIterator = source.getRangeIterator(sourceRanges);
        IndexIterator targetRangeIterator = target.getRangeIterator(targetRanges);
        Class elementType = source.getElementType();
        ValueSetter setter = PartialDataCopier.createValueSetter(elementType);
        while (sourceRangeIterator.hasNext()) {
            setter.set(sourceRangeIterator, targetRangeIterator);
        }
    }

    private static ValueSetter createValueSetter(Class elementType) {
        if (elementType == Double.TYPE) {
            return (sourceIterator, targetIterator) -> targetIterator.setDoubleNext(sourceIterator.getDoubleNext());
        }
        if (elementType == Float.TYPE) {
            return (sourceIterator, targetIterator) -> targetIterator.setFloatNext(sourceIterator.getFloatNext());
        }
        if (elementType == Long.TYPE) {
            return (sourceIterator, targetIterator) -> targetIterator.setLongNext(sourceIterator.getLongNext());
        }
        if (elementType == Integer.TYPE) {
            return (sourceIterator, targetIterator) -> targetIterator.setIntNext(sourceIterator.getIntNext());
        }
        if (elementType == Short.TYPE) {
            return (sourceIterator, targetIterator) -> targetIterator.setShortNext(sourceIterator.getShortNext());
        }
        if (elementType == Byte.TYPE) {
            return (sourceIterator, targetIterator) -> targetIterator.setByteNext(sourceIterator.getByteNext());
        }
        return (sourceIterator, targetIterator) -> targetIterator.setObjectNext(sourceIterator.getObjectNext());
    }

    private static interface ValueSetter {
        public void set(IndexIterator var1, IndexIterator var2);
    }
}

