/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.beam;

import java.io.IOException;
import org.esa.snap.core.dataio.ProductIOException;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfInitialisationPart;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;

public class BeamInitialisationPart
extends CfInitialisationPart {
    public static final String PRODUCT_TYPE = "product_type";

    @Override
    public Product readProductBody(ProfileReadContext ctx) throws ProductIOException {
        Dimension x = null;
        Dimension y = null;
        for (Dimension dimension : ctx.getNetcdfFile().getDimensions()) {
            String name = dimension.getShortName();
            if ("x".equalsIgnoreCase(name) || "lon".equalsIgnoreCase(name) || "lon_intern".equalsIgnoreCase(name)) {
                x = dimension;
                continue;
            }
            if (!"y".equalsIgnoreCase(name) && !"lat".equalsIgnoreCase(name) && !"lat_intern".equalsIgnoreCase(name)) continue;
            y = dimension;
        }
        if (x == null || y == null) {
            throw new ProductIOException("Illegal Dimensions: Dimensions named (x,lon,lon_intern) and (y,lat,lat_intern) expected.");
        }
        Product product = new Product((String)ctx.getProperty("productName"), this.readProductType(ctx), x.getLength(), y.getLength());
        this.initPreferredTileSize(ctx, product);
        return product;
    }

    @Override
    public void writeProductBody(ProfileWriteContext ctx, Product p) throws IOException {
        super.writeProductBody(ctx, p);
        NFileWriteable writeable = ctx.getNetcdfFileWriteable();
        writeable.addGlobalAttribute(PRODUCT_TYPE, p.getProductType());
        writeable.addGlobalAttribute("metadata_profile", "beam");
        writeable.addGlobalAttribute("metadata_version", "0.5");
    }

    @Override
    public String readProductType(ProfileReadContext ctx) {
        String pt;
        Attribute productTypeAtt = ctx.getNetcdfFile().findGlobalAttribute(PRODUCT_TYPE);
        if (productTypeAtt != null && (pt = productTypeAtt.getStringValue()) != null && pt.trim().length() > 0) {
            return pt.trim();
        }
        return super.readProductType(ctx);
    }
}

