/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.beam;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductVisitor;
import org.esa.snap.core.datamodel.ProductVisitorAdapter;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import org.esa.snap.dataio.netcdf.util.MetadataUtils;
import org.esa.snap.dataio.netcdf.util.VariableNameHelper;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class BeamMetadataPart
extends ProfilePartIO {
    private static final String SPLITTER = ":";
    private static final String SPLITTER2 = "%3a";
    private static final String DATA_SPLITTER = "___dataSplitter_";
    private static final String METADATA_VARIABLE = "metadata";
    private static final String DESCRIPTION_SUFFIX = "descr";
    private static final String UNIT_SUFFIX = "unit";
    private static final List<String> SNAP_GLOBAL_ATTRIBUTES = Arrays.asList("Conventions", "TileSize", "product_type", "metadata_profile", "metadata_version", "start_date", "stop_date", "auto_grouping", "quicklook_band_name", "tiepoint_coordinates", "title");
    private boolean isNC4 = false;

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        NetcdfFile netcdfFile = ctx.getNetcdfFile();
        Variable metadata = netcdfFile.getRootGroup().findVariable(METADATA_VARIABLE);
        MetadataElement metadataRoot = p.getMetadataRoot();
        MetadataUtils.readNetcdfMetadata(netcdfFile, p.getMetadataRoot());
        if (metadata != null) {
            for (Attribute attribute : metadata.getAttributes()) {
                String prefix;
                String attrName = attribute.getShortName();
                if (attrName.startsWith(SPLITTER)) {
                    attrName = attrName.substring(SPLITTER.length());
                } else if (attrName.startsWith(SPLITTER2)) {
                    attrName = attrName.substring(SPLITTER2.length());
                }
                if (attrName.contains(SPLITTER)) {
                    prefix = attrName.split(SPLITTER)[0];
                    this.readMetadata(attribute, metadataRoot, prefix, SPLITTER);
                    continue;
                }
                if (attrName.contains(SPLITTER2)) {
                    prefix = attrName.split(SPLITTER2)[0];
                    this.readMetadata(attribute, metadataRoot, prefix, SPLITTER2);
                    continue;
                }
                ProductData attributeValue = DataTypeUtils.createProductData(attribute);
                metadataRoot.addAttribute(new MetadataAttribute(attrName, attributeValue, true));
            }
        }
        this.spliceAttributes(metadataRoot);
    }

    private void readMetadata(Attribute attribute, MetadataElement metadataRoot, String prefix, String splitter) {
        String temp;
        MetadataElement metadataElement;
        String[] splittedPrefix = prefix.split(splitter);
        String metaDataElementName = prefix;
        if (splittedPrefix.length > 1) {
            metaDataElementName = splittedPrefix[splittedPrefix.length - 1];
        }
        if ((metadataElement = metadataRoot.getElement(metaDataElementName)) == null) {
            metadataElement = new MetadataElement(metaDataElementName);
            metadataRoot.addElement(metadataElement);
        }
        if ((temp = attribute.getShortName()).startsWith(splitter)) {
            temp = temp.substring(splitter.length());
        }
        if ((temp = temp.replaceFirst(prefix, "")).startsWith(splitter)) {
            temp = temp.substring(splitter.length());
        }
        String[] splittedAttrName = temp.split(splitter);
        temp = splittedAttrName[0];
        if (splittedAttrName.length > 1) {
            this.readMetadata(attribute, metadataElement, prefix + splitter + temp, splitter);
        } else {
            String newAttributeName = attribute.getShortName().replaceFirst(prefix, "").replace(splitter, "");
            if (newAttributeName.endsWith(".unit")) {
                newAttributeName = newAttributeName.substring(0, newAttributeName.length() - UNIT_SUFFIX.length() - 1);
                MetadataAttribute anAttribute = metadataElement.getAttribute(newAttributeName);
                String value = attribute.getStringValue();
                if (value != null) {
                    anAttribute.setUnit(value);
                }
            } else if (newAttributeName.endsWith(".descr")) {
                newAttributeName = newAttributeName.substring(0, newAttributeName.length() - DESCRIPTION_SUFFIX.length() - 1);
                MetadataAttribute anAttribute = metadataElement.getAttribute(newAttributeName);
                String value = attribute.getStringValue();
                if (value != null) {
                    anAttribute.setDescription(value);
                }
            } else {
                ProductData attributeValue = DataTypeUtils.createProductData(attribute);
                MetadataAttribute newAttribute = new MetadataAttribute(newAttributeName, attributeValue, true);
                metadataElement.addAttribute(newAttribute);
            }
        }
    }

    private void spliceAttributes(MetadataElement metadataRoot) {
        metadataRoot.acceptVisitor((ProductVisitor)new ProductVisitorAdapter(){

            public void visit(MetadataElement element) {
                MetadataAttribute[] attributes = element.getAttributes();
                HashMap toSplice = new HashMap();
                for (MetadataAttribute attribute : attributes) {
                    String attributeName = attribute.getName();
                    if (!attributeName.contains(BeamMetadataPart.DATA_SPLITTER)) continue;
                    String[] strings = attributeName.split(BeamMetadataPart.DATA_SPLITTER);
                    String realAttName = strings[0];
                    int idx = Integer.parseInt(strings[1]);
                    if (!toSplice.containsKey(realAttName)) {
                        toSplice.put(realAttName, new TreeMap());
                    }
                    ((TreeMap)toSplice.get(realAttName)).put(idx, attribute);
                }
                for (Map.Entry entry : toSplice.entrySet()) {
                    String realAttName = (String)entry.getKey();
                    TreeMap splittedAttributes = (TreeMap)entry.getValue();
                    MetadataAttribute firstAttribute = null;
                    Array realDataArray = null;
                    for (int i = 0; i < splittedAttributes.size(); ++i) {
                        MetadataAttribute currentAttribute = (MetadataAttribute)splittedAttributes.get(i);
                        if (firstAttribute == null) {
                            firstAttribute = currentAttribute.createDeepClone();
                            realDataArray = Array.factory((DataType)DataTypeUtils.getNetcdfDataType(firstAttribute.getData().getType()), (int[])new int[]{firstAttribute.getData().getNumElems()}, (Object)firstAttribute.getData().getElems());
                        } else {
                            ProductData currentData = currentAttribute.getData();
                            Array currentDataArray = Array.factory((DataType)DataTypeUtils.getNetcdfDataType(currentData.getType()), (int[])new int[]{currentData.getNumElems()}, (Object)currentData.getElems());
                            int newSize = (int)realDataArray.getSize() + currentData.getNumElems();
                            ProductData newData = firstAttribute.createCompatibleProductData(newSize);
                            Array newDataArray = Array.factory((DataType)DataTypeUtils.getNetcdfDataType(newData.getType()), (int[])new int[]{newData.getNumElems()}, (Object)newData.getElems());
                            Array.arraycopy((Array)realDataArray, (int)0, (Array)newDataArray, (int)0, (int)((int)realDataArray.getSize()));
                            Array.arraycopy((Array)currentDataArray, (int)0, (Array)newDataArray, (int)((int)realDataArray.getSize()), (int)((int)currentDataArray.getSize()));
                            realDataArray = newDataArray;
                        }
                        element.removeAttribute(currentAttribute);
                    }
                    ProductData newData = ProductData.createInstance((int)firstAttribute.getDataType(), (Object)realDataArray.getStorage());
                    MetadataAttribute attribute = new MetadataAttribute(realAttName, newData, firstAttribute.isReadOnly());
                    attribute.setDescription(firstAttribute.getDescription());
                    attribute.setUnit(firstAttribute.getUnit());
                    element.addAttribute(attribute);
                }
            }
        });
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        MetadataElement globalAttributes;
        this.isNC4 = this.isNetCDF4(p);
        MetadataElement root = p.getMetadataRoot();
        if (root != null) {
            NFileWriteable ncFile = ctx.getNetcdfFileWriteable();
            NVariable variable = ncFile.addScalarVariable(METADATA_VARIABLE, DataType.BYTE);
            this.writeMetadataElement(ncFile, root, variable, "");
        }
        if ((globalAttributes = root.getElement("Global_Attributes")) != null) {
            for (int i = 0; i < globalAttributes.getNumAttributes(); ++i) {
                Object value;
                MetadataAttribute attribute = globalAttributes.getAttributeAt(i);
                String attributeName = attribute.getName();
                if (!VariableNameHelper.isVariableNameValid(attributeName)) {
                    attributeName = VariableNameHelper.convertToValidName(attributeName);
                    SystemUtils.LOG.warning("Found invalid attribute name '" + attribute.getName() + "' - replaced by '" + attributeName + "'.");
                }
                if (SNAP_GLOBAL_ATTRIBUTES.contains(attributeName)) continue;
                ProductData productData = attribute.getData();
                if (productData.isInt()) {
                    value = productData.getElemInt();
                    ctx.getNetcdfFileWriteable().addGlobalAttribute(attributeName, (Number)value);
                    continue;
                }
                if (productData instanceof ProductData.Double) {
                    value = productData.getElemDouble();
                    ctx.getNetcdfFileWriteable().addGlobalAttribute(attributeName, (Number)value);
                    continue;
                }
                if (productData instanceof ProductData.Float) {
                    value = Float.valueOf(productData.getElemFloat());
                    ctx.getNetcdfFileWriteable().addGlobalAttribute(attributeName, (Number)value);
                    continue;
                }
                if (productData instanceof ProductData.ASCII || productData instanceof ProductData.UTC) {
                    value = productData.getElemString();
                    ctx.getNetcdfFileWriteable().addGlobalAttribute(attributeName, (String)value);
                    continue;
                }
                value = Stream.of(productData.getElems()).map(String::valueOf).collect(Collectors.joining(","));
                ctx.getNetcdfFileWriteable().addGlobalAttribute(attributeName, (String)value);
            }
        }
    }

    private void writeMetadataElement(NFileWriteable ncFile, MetadataElement element, NVariable ncVariable, String prefix) throws IOException {
        int i;
        for (i = 0; i < element.getNumAttributes(); ++i) {
            MetadataAttribute attribute = element.getAttributeAt(i);
            this.writeMetadataAttribute(ncFile, attribute, ncVariable, prefix);
        }
        for (i = 0; i < element.getNumElements(); ++i) {
            MetadataElement subElement = element.getElementAt(i);
            String subElementName = subElement.getName();
            if (this.isGlobalAttributesElement(subElementName)) continue;
            String name = prefix.isEmpty() ? subElementName : prefix + SPLITTER + subElementName;
            this.writeMetadataElement(ncFile, subElement, ncVariable, name);
        }
    }

    private boolean isGlobalAttributesElement(String subElementName) {
        return "Global_Attributes".equals(subElementName) || "Variable_Attributes".equals(subElementName);
    }

    private void writeMetadataAttribute(NFileWriteable ncFile, MetadataAttribute metadataAttr, NVariable ncVariable, String prefix) throws IOException {
        ProductData productData = metadataAttr.getData();
        String ncAttributeName = prefix.isEmpty() ? metadataAttr.getName() : prefix + SPLITTER + metadataAttr.getName();
        if (!ncFile.isNameValid(ncAttributeName)) {
            ncAttributeName = ncFile.makeNameValid(ncAttributeName);
        }
        if (productData instanceof ProductData.ASCII || productData instanceof ProductData.UTC) {
            ncVariable.addAttribute(ncAttributeName, productData.getElemString());
        } else {
            DataType dataType = DataTypeUtils.getNetcdfDataType(productData.getType());
            Array value = Array.factory((DataType)dataType, (int[])new int[]{productData.getNumElems()}, (Object)productData.getElems());
            int maxSizeInBytes = 64535;
            long sizeBytes = value.getSizeBytes();
            if (this.isNC4 && value.getRank() == 1 && sizeBytes > (long)maxSizeInBytes) {
                int elemSize = dataType.getSize();
                int maxSectionSize = maxSizeInBytes / elemSize;
                int size = (int)value.getSize();
                int startIdx = 0;
                int nameIdx = 0;
                while (startIdx < size) {
                    int newSize = startIdx + maxSectionSize < size ? maxSectionSize : size - startIdx;
                    try {
                        Array section = value.section(new int[]{startIdx}, new int[]{newSize});
                        ncVariable.addAttribute(ncAttributeName + DATA_SPLITTER + nameIdx, section.copy());
                    }
                    catch (InvalidRangeException e) {
                        throw new IllegalStateException("Error 726354921 ... should never come here", e);
                    }
                    startIdx += maxSectionSize;
                    ++nameIdx;
                }
            } else {
                ncVariable.addAttribute(ncAttributeName, value);
            }
        }
        if (metadataAttr.getUnit() != null) {
            ncVariable.addAttribute(ncAttributeName + "." + UNIT_SUFFIX, metadataAttr.getUnit());
        }
        if (metadataAttr.getDescription() != null) {
            ncVariable.addAttribute(ncAttributeName + "." + DESCRIPTION_SUFFIX, metadataAttr.getDescription());
        }
    }

    private boolean isNetCDF4(Product p) {
        return p.getProductWriter().getWriterPlugIn().getFormatNames()[0].toLowerCase().contains("netcdf4");
    }
}

