/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.beam;

import java.util.Locale;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.dataio.netcdf.AbstractNetCdfReaderPlugIn;
import org.esa.snap.dataio.netcdf.metadata.ProfileInitPartReader;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartReader;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamBandPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamFlagCodingPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamGeocodingPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamImageInfoPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamIndexCodingPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamInitialisationPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamMaskPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamMetadataPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamStxPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamTiePointGridPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfDescriptionPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfTimePart;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;

public class BeamNetCdfReaderPlugIn
extends AbstractNetCdfReaderPlugIn {
    @Override
    protected DecodeQualification getDecodeQualification(NetcdfFile netcdfFile) {
        String value;
        Attribute attribute = netcdfFile.getRootGroup().findAttribute("metadata_profile");
        if (attribute != null && (value = attribute.getStringValue()) != null && value.equals("beam")) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public String[] getFormatNames() {
        return new String[]{"NetCDF-BEAM", "NetCDF4-BEAM"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".nc", ".nc.gz"};
    }

    public String getDescription(Locale locale) {
        return "BEAM NetCDF products";
    }

    @Override
    public ProfileInitPartReader createInitialisationPartReader() {
        return new BeamInitialisationPart();
    }

    @Override
    public ProfilePartReader createMetadataPartReader() {
        return new BeamMetadataPart();
    }

    @Override
    public ProfilePartReader createBandPartReader() {
        return new BeamBandPart();
    }

    @Override
    public ProfilePartReader createDescriptionPartReader() {
        return new CfDescriptionPart();
    }

    @Override
    public ProfilePartReader createFlagCodingPartReader() {
        return new BeamFlagCodingPart();
    }

    @Override
    public ProfilePartReader createGeoCodingPartReader() {
        return new BeamGeocodingPart();
    }

    @Override
    public ProfilePartReader createImageInfoPartReader() {
        return new BeamImageInfoPart();
    }

    @Override
    public ProfilePartReader createIndexCodingPartReader() {
        return new BeamIndexCodingPart();
    }

    @Override
    public ProfilePartReader createMaskPartReader() {
        return new BeamMaskPart();
    }

    @Override
    public ProfilePartReader createTimePartReader() {
        return new CfTimePart();
    }

    @Override
    public ProfilePartReader createStxPartReader() {
        return new BeamStxPart();
    }

    @Override
    public ProfilePartReader createTiePointGridPartReader() {
        return new BeamTiePointGridPart();
    }
}

