/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.beam;

import java.io.IOException;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.datamodel.StxFactory;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class BeamStxPart
extends ProfilePartIO {
    public final String STATISTICS = "statistics";
    public final String SAMPLE_FREQUENCIES = "sample_frequencies";
    public final int INDEX_SCALED_MIN = 0;
    public final int INDEX_SCALED_MAX = 1;
    public final int INDEX_MEAN = 2;
    public final int INDEX_STANDARD_DEVIATION = 3;

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        for (Band band : p.getBands()) {
            String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
            Variable variable = ctx.getNetcdfFile().getRootGroup().findVariable(variableName);
            Attribute statistics = variable.findAttributeIgnoreCase("statistics");
            Attribute sampleFrequencies = variable.findAttributeIgnoreCase("sample_frequencies");
            if (statistics == null || sampleFrequencies == null || statistics.getLength() < 2) continue;
            double min = statistics.getNumericValue(0).doubleValue();
            double max = statistics.getNumericValue(1).doubleValue();
            Number meanNumber = statistics.getNumericValue(2);
            double mean = meanNumber != null ? meanNumber.doubleValue() : Double.NaN;
            Number stdDevNumber = statistics.getNumericValue(3);
            double stdDev = stdDevNumber != null ? stdDevNumber.doubleValue() : Double.NaN;
            boolean intHistogram = !ProductData.isFloatingPointType((int)band.getGeophysicalDataType());
            int[] frequencies = new int[sampleFrequencies.getLength()];
            for (int i = 0; i < frequencies.length; ++i) {
                Number fNumber = sampleFrequencies.getNumericValue(i);
                frequencies[i] = fNumber != null ? fNumber.intValue() : 0;
            }
            boolean resolutionLevel = false;
            Stx stx = new StxFactory().withMinimum((Number)min).withMaximum((Number)max).withMean((Number)mean).withStandardDeviation((Number)stdDev).withIntHistogram(intHistogram).withHistogramBins(frequencies).withResolutionLevel(Integer.valueOf(0)).create();
            band.setStx(stx);
        }
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        for (Band band : p.getBands()) {
            if (!band.isStxSet()) continue;
            String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
            Stx stx = band.getStx();
            NVariable variable = ctx.getNetcdfFileWriteable().findVariable(variableName);
            if (variable == null) continue;
            double[] statistics = new double[]{stx.getMinimum(), stx.getMaximum(), stx.getMean(), stx.getStandardDeviation()};
            variable.addAttribute("statistics", Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{4}, (Object)statistics));
            variable.addAttribute("sample_frequencies", Array.factory((DataType)DataType.INT, (int[])new int[]{stx.getHistogramBinCount()}, (Object)stx.getHistogramBins()));
        }
    }
}

