/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.cf;

import java.io.IOException;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import ucar.nc2.Attribute;

public class CfDescriptionPart
extends ProfilePartIO {
    private static final String DESCRIPTION = "description";
    private static final String TITLE = "title";
    private static final String COMMENT = "comment";
    private static final String[] DESCRIPTION_ATTRIBUTE_NAMES = new String[]{"description", "title", "comment"};

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        for (String attribName : DESCRIPTION_ATTRIBUTE_NAMES) {
            String description;
            Attribute attribute = ctx.getNetcdfFile().getRootGroup().findAttribute(attribName);
            if (attribute == null || (description = attribute.getStringValue()) == null) continue;
            p.setDescription(description);
            return;
        }
        p.setDescription("NetCDF/CF Data Product");
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        String description = p.getDescription();
        if (description != null && description.trim().length() > 0) {
            NFileWriteable netcdfFileWriteable = ctx.getNetcdfFileWriteable();
            netcdfFileWriteable.addGlobalAttribute(TITLE, description);
        }
    }
}

