/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.cf;

import java.awt.Dimension;
import java.io.IOException;
import java.util.List;
import org.esa.snap.core.dataio.ProductIOException;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfileInitPartIO;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfGeocodingPart;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class CfInitialisationPart
extends ProfileInitPartIO {
    @Override
    public Product readProductBody(ProfileReadContext ctx) throws ProductIOException {
        Product product = new Product((String)ctx.getProperty("productName"), this.readProductType(ctx), ctx.getRasterDigest().getRasterDim().getDimensionX().getLength(), ctx.getRasterDigest().getRasterDim().getDimensionY().getLength());
        this.initPreferredTileSize(ctx, product);
        return product;
    }

    protected void initPreferredTileSize(ProfileReadContext ctx, Product product) {
        if (!this.initPreferredTileSizeFromChunkSizes(ctx, product)) {
            this.initPreferredTileSizeFromGAttribute(ctx, product);
        }
    }

    private void initPreferredTileSizeFromGAttribute(ProfileReadContext ctx, Product product) {
        String[] tileSizes;
        String stringValue;
        Attribute tileSize = ctx.getNetcdfFile().findGlobalAttribute("TileSize");
        if (tileSize != null && (stringValue = tileSize.getStringValue()) != null && stringValue.contains(":") && (tileSizes = stringValue.split(":")).length == 2) {
            try {
                int tHeight = Integer.parseInt(tileSizes[0]);
                int tWidth = Integer.parseInt(tileSizes[1]);
                product.setPreferredTileSize(tWidth, tHeight);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private boolean initPreferredTileSizeFromChunkSizes(ProfileReadContext ctx, Product product) {
        Attribute att;
        List variables = ctx.getNetcdfFile().getVariables();
        Variable variable = this.getFirst2dVariable(variables);
        if (variable != null && (att = variable.findAttribute("_ChunkSizes")) != null) {
            Number numericValue = att.getNumericValue(0);
            Number numericValue1 = att.getNumericValue(1);
            if (numericValue != null && numericValue1 != null) {
                product.setPreferredTileSize(numericValue.intValue(), numericValue1.intValue());
                return true;
            }
        }
        return false;
    }

    private Variable getFirst2dVariable(List<Variable> variables) {
        for (Variable variable : variables) {
            List dimensions = variable.getDimensions();
            if (dimensions.size() != 2) continue;
            return variable;
        }
        return null;
    }

    @Override
    public void writeProductBody(ProfileWriteContext ctx, Product product) throws IOException {
        NFileWriteable writeable = ctx.getNetcdfFileWriteable();
        writeable.addGlobalAttribute("Conventions", "CF-1.4");
        if (!this.isLatLonPresent(product) && CfGeocodingPart.isGeographicCRS(product.getSceneGeoCoding())) {
            this.writeDimensions(writeable, product, "lat", "lon");
        } else if (this.isLatLonPresent(product) && CfGeocodingPart.isGeographicCRS(product.getSceneGeoCoding())) {
            this.writeDimensions(writeable, product, "lat_intern", "lon_intern");
        } else {
            this.writeDimensions(writeable, product, "y", "x");
        }
        Dimension tileSize = ImageManager.getPreferredTileSize((Product)product);
        writeable.addGlobalAttribute("TileSize", tileSize.height + ":" + tileSize.width);
    }

    private boolean isLatLonPresent(Product product) {
        return product.containsRasterDataNode("lat") && product.containsRasterDataNode("lon");
    }

    private void writeDimensions(NFileWriteable writeable, Product p, String dimY, String dimX) throws IOException {
        writeable.addDimension(dimY, p.getSceneRasterHeight());
        writeable.addDimension(dimX, p.getSceneRasterWidth());
    }

    public String readProductType(ProfileReadContext ctx) {
        Attribute productType = ctx.getNetcdfFile().findGlobalAttribute("Conventions");
        if (productType != null && StringUtils.isNotNullAndNotEmpty((String)productType.getStringValue())) {
            return productType.getStringValue();
        }
        return "NetCDF";
    }
}

