/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.cf;

import java.io.IOException;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.util.MetadataUtils;
import org.esa.snap.dataio.netcdf.util.VariableNameHelper;

public class CfMetadataPart
extends ProfilePartIO {
    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        MetadataUtils.readNetcdfMetadata(ctx.getNetcdfFile(), p.getMetadataRoot());
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        MetadataAttribute[] globalAttributes;
        NFileWriteable netcdfFileWriteable = ctx.getNetcdfFileWriteable();
        MetadataElement metadataRoot = p.getMetadataRoot();
        for (MetadataAttribute attribute : globalAttributes = metadataRoot.getAttributes()) {
            int dataType = attribute.getDataType();
            String attributeName = attribute.getName();
            if (!VariableNameHelper.isVariableNameValid(attributeName)) {
                attributeName = VariableNameHelper.convertToValidName(attributeName);
                SystemUtils.LOG.warning("Found invalid attribute name '" + attribute.getName() + "' - replaced by '" + attributeName + "'.");
            }
            if (dataType == 41) {
                netcdfFileWriteable.addGlobalAttribute(attributeName, attribute.getData().getElemString());
                continue;
            }
            if (attribute.getNumDataElems() > 1L) continue;
            if (dataType == 10 || dataType == 20 || dataType == 11 || dataType == 21 || dataType == 12 || dataType == 22) {
                int data = attribute.getData().getElemInt();
                netcdfFileWriteable.addGlobalAttribute(attributeName, data);
                continue;
            }
            if (dataType == 30) {
                float data = attribute.getData().getElemFloat();
                netcdfFileWriteable.addGlobalAttribute(attributeName, Float.valueOf(data));
                continue;
            }
            if (dataType == 31) {
                double data = attribute.getData().getElemDouble();
                netcdfFileWriteable.addGlobalAttribute(attributeName, data);
                continue;
            }
            if (dataType != 13) continue;
            long data = (long)attribute.getData().getElemDouble();
            netcdfFileWriteable.addGlobalAttribute(attributeName, data);
        }
    }
}

