/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.cf;

import java.io.IOException;
import java.util.Locale;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.netcdf.AbstractNetCdfWriterPlugIn;
import org.esa.snap.dataio.netcdf.metadata.ProfileInitPartWriter;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartWriter;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfBandPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfDescriptionPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfFlagCodingPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfGeocodingPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfIndexCodingPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfInitialisationPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfMetadataPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfTiePointGridPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfTimePart;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NWritableFactory;

public class CfNetCdfWriterPlugIn
extends AbstractNetCdfWriterPlugIn {
    public EncodeQualification getEncodeQualification(Product product) {
        if (product.isMultiSize()) {
            return new EncodeQualification(EncodeQualification.Preservation.UNABLE, "Cannot write multisize products. Consider resampling the product first.");
        }
        return new EncodeQualification(EncodeQualification.Preservation.PARTIAL);
    }

    public String[] getFormatNames() {
        return new String[]{"NetCDF-CF"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".nc"};
    }

    public String getDescription(Locale locale) {
        return "NetCDF following CF-Convention";
    }

    @Override
    public NFileWriteable createWritable(String outputPath) throws IOException {
        return NWritableFactory.create(outputPath, "netcdf3");
    }

    @Override
    public ProfileInitPartWriter createInitialisationPartWriter() {
        return new CfInitialisationPart();
    }

    @Override
    public ProfilePartWriter createMetadataPartWriter() {
        return new CfMetadataPart();
    }

    @Override
    public ProfilePartWriter createBandPartWriter() {
        return new CfBandPart();
    }

    @Override
    public ProfilePartWriter createFlagCodingPartWriter() {
        return new CfFlagCodingPart();
    }

    @Override
    public ProfilePartWriter createIndexCodingPartWriter() {
        return new CfIndexCodingPart();
    }

    @Override
    public ProfilePartWriter createGeoCodingPartWriter() {
        return new CfGeocodingPart();
    }

    @Override
    public ProfilePartWriter createTiePointGridPartWriter() {
        return new CfTiePointGridPart();
    }

    @Override
    public ProfilePartWriter createTimePartWriter() {
        return new CfTimePart();
    }

    @Override
    public ProfilePartWriter createDescriptionPartWriter() {
        return new CfDescriptionPart();
    }
}

