/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.cf;

import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.util.StringUtils;
import ucar.ma2.DataType;

class DataTypeWorkarounds {
    private final Map<NameTypePair, Integer> workaroundMap = new HashMap<NameTypePair, Integer>();

    DataTypeWorkarounds() {
        this.workaroundMap.put(new NameTypePair("fapar", DataType.BYTE), 20);
        this.workaroundMap.put(new NameTypePair("sd_spatial_fapar", DataType.BYTE), 20);
        this.workaroundMap.put(new NameTypePair("nb_spatial_fapar", DataType.SHORT), 21);
    }

    public boolean hasWorkaround(String variableName, DataType dataType) {
        if (StringUtils.isNullOrEmpty((String)variableName) || dataType == null) {
            return false;
        }
        NameTypePair nameTypePair = new NameTypePair(variableName, dataType);
        return this.workaroundMap.containsKey(nameTypePair);
    }

    public int getRasterDataType(String variableName, DataType dataType) {
        if (StringUtils.isNullOrEmpty((String)variableName) || dataType == null) {
            throw new IllegalArgumentException();
        }
        NameTypePair nameTypePair = new NameTypePair(variableName, dataType);
        return this.workaroundMap.get(nameTypePair);
    }

    private static class NameTypePair {
        final String variableName;
        final DataType dataType;

        public NameTypePair(String variableName, DataType dataType) {
            this.variableName = variableName;
            this.dataType = dataType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameTypePair that = (NameTypePair)o;
            return this.dataType == that.dataType && this.variableName.equals(that.variableName);
        }

        public int hashCode() {
            int result = this.variableName.hashCode();
            result = 31 * result + this.dataType.hashCode();
            return result;
        }
    }
}

