/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom2.Element;

class HdfEosGridInfo {
    final String gridName;
    final double upperLeftLon;
    final double upperLeftLat;
    final double lowerRightLon;
    final double lowerRightLat;
    final String projection;
    private double[] projectionParameter;

    HdfEosGridInfo(String gridName, double upperLeftLon, double upperLeftLat, double lowerRightLon, double lowerRightLat, String projection) {
        this.gridName = gridName;
        this.upperLeftLon = upperLeftLon;
        this.upperLeftLat = upperLeftLat;
        this.lowerRightLon = lowerRightLon;
        this.lowerRightLat = lowerRightLat;
        this.projection = projection;
    }

    public boolean equalProjections(HdfEosGridInfo that) {
        if (this == that) {
            return true;
        }
        if (Double.compare(that.lowerRightLat, this.lowerRightLat) != 0) {
            return false;
        }
        if (Double.compare(that.lowerRightLon, this.lowerRightLon) != 0) {
            return false;
        }
        if (Double.compare(that.upperLeftLat, this.upperLeftLat) != 0) {
            return false;
        }
        if (Double.compare(that.upperLeftLon, this.upperLeftLon) != 0) {
            return false;
        }
        if (!Arrays.equals(that.projectionParameter, this.projectionParameter)) {
            return false;
        }
        return this.projection.equals(that.projection);
    }

    static List<HdfEosGridInfo> getCompatibleGridInfos(List<HdfEosGridInfo> allGridInfos) {
        ArrayList<HdfEosGridInfo> compatibleGridInfos = new ArrayList<HdfEosGridInfo>();
        if (allGridInfos.isEmpty()) {
            return compatibleGridInfos;
        }
        HdfEosGridInfo first = allGridInfos.get(0);
        for (HdfEosGridInfo gridInfo : allGridInfos) {
            if (!first.equalProjections(gridInfo)) continue;
            compatibleGridInfos.add(gridInfo);
        }
        return compatibleGridInfos;
    }

    static List<HdfEosGridInfo> createGridInfos(Element eosStructElement) {
        Element gridStructureElem;
        ArrayList<HdfEosGridInfo> gridInfos = new ArrayList<HdfEosGridInfo>();
        if (eosStructElement != null && (gridStructureElem = eosStructElement.getChild("GridStructure")) != null) {
            for (Element gridElem : gridStructureElem.getChildren()) {
                HdfEosGridInfo gridInfo;
                if (gridElem == null || (gridInfo = HdfEosGridInfo.createGridInfo(gridElem)) == null) continue;
                gridInfos.add(gridInfo);
            }
        }
        return gridInfos;
    }

    static HdfEosGridInfo createGridInfo(Element gridElem) {
        Element gridNameElem = gridElem.getChild("GridName");
        Element projectionElem = gridElem.getChild("Projection");
        Element ulPointElem = gridElem.getChild("UpperLeftPointMtrs");
        Element lrPointElem = gridElem.getChild("LowerRightMtrs");
        Element projParamsElem = gridElem.getChild("ProjParams");
        if (gridNameElem == null || projectionElem == null || ulPointElem == null || lrPointElem == null) {
            return null;
        }
        String gridName = gridNameElem.getValue();
        if (gridName.isEmpty()) {
            return null;
        }
        List ulList = ulPointElem.getChildren();
        String ulLon = ((Element)ulList.get(0)).getValue();
        String ulLat = ((Element)ulList.get(1)).getValue();
        double upperLeftLon = Double.parseDouble(ulLon);
        double upperLeftLat = Double.parseDouble(ulLat);
        List lrList = lrPointElem.getChildren();
        String lrLon = ((Element)lrList.get(0)).getValue();
        String lrLat = ((Element)lrList.get(1)).getValue();
        double lowerRightLon = Double.parseDouble(lrLon);
        double lowerRightLat = Double.parseDouble(lrLat);
        String projection = projectionElem.getValue();
        HdfEosGridInfo hdfEosGridInfo = new HdfEosGridInfo(gridName, upperLeftLon, upperLeftLat, lowerRightLon, lowerRightLat, projection);
        if (projParamsElem != null) {
            List children = projParamsElem.getChildren();
            double[] projParameterValues = new double[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                Element child = (Element)children.get(i);
                projParameterValues[i] = Double.parseDouble(child.getValue());
            }
            hdfEosGridInfo.setProjectionParameter(projParameterValues);
        }
        return hdfEosGridInfo;
    }

    public void setProjectionParameter(double[] projectionParameter) {
        this.projectionParameter = (double[])(projectionParameter != null ? (double[])projectionParameter.clone() : null);
    }

    public double[] getProjectionParameter() {
        return this.projectionParameter;
    }
}

