/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductIOException;
import org.esa.snap.dataio.netcdf.AbstractNetCdfReaderPlugIn;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.metadata.ProfileInitPartReader;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartReader;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfInitialisationPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos.HdfEosBandPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos.HdfEosDescriptionPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos.HdfEosGeocodingPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos.HdfEosGridInfo;
import org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos.HdfEosMetadataPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos.HdfEosTimePart;
import org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos.HdfEosUtils;
import org.esa.snap.dataio.netcdf.util.RasterDigest;
import org.jdom2.Element;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;

public class HdfEosNetCdfReaderPlugIn
extends AbstractNetCdfReaderPlugIn {
    @Override
    protected DecodeQualification getDecodeQualification(NetcdfFile netcdfFile) {
        try {
            Element eosElement = HdfEosUtils.getEosElement("StructMetadata", netcdfFile.getRootGroup());
            if (!HdfEosGridInfo.createGridInfos(eosElement).isEmpty()) {
                return DecodeQualification.INTENDED;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DecodeQualification.UNABLE;
    }

    @Override
    protected void initReadContext(ProfileReadContext ctx) throws IOException {
        Group eosGroup = ctx.getNetcdfFile().getRootGroup();
        Element eosElement = HdfEosUtils.getEosElement("StructMetadata", eosGroup);
        List<HdfEosGridInfo> gridInfos = HdfEosGridInfo.createGridInfos(eosElement);
        List<HdfEosGridInfo> compatibleGridInfos = HdfEosGridInfo.getCompatibleGridInfos(gridInfos);
        if (compatibleGridInfos.isEmpty()) {
            throw new ProductIOException("Could not find grids.");
        }
        ArrayList<Group> gridGroups = new ArrayList<Group>();
        for (HdfEosGridInfo gridInfo : compatibleGridInfos) {
            gridGroups.add(HdfEosUtils.findGroupNested(eosGroup, gridInfo.gridName));
        }
        if (gridGroups.isEmpty()) {
            throw new ProductIOException("Could not find grid group.");
        }
        Group[] groups = gridGroups.toArray(new Group[gridGroups.size()]);
        RasterDigest rasterDigest = RasterDigest.createRasterDigest(groups);
        ctx.setRasterDigest(rasterDigest);
        ctx.setProperty("StructMetadata", eosElement);
        ctx.setProperty("CoreMetadata", HdfEosUtils.getEosElement("CoreMetadata", eosGroup));
        ctx.setProperty("ArchiveMetadata", HdfEosUtils.getEosElement("ArchiveMetadata", eosGroup));
    }

    @Override
    public ProfileInitPartReader createInitialisationPartReader() {
        return new CfInitialisationPart();
    }

    public String[] getFormatNames() {
        return new String[]{"HDF-EOS"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".hdf", ".hdf.gz"};
    }

    public String getDescription(Locale locale) {
        return "HDF-EOS products";
    }

    @Override
    public ProfilePartReader createBandPartReader() {
        return new HdfEosBandPart();
    }

    @Override
    public ProfilePartReader createGeoCodingPartReader() {
        return new HdfEosGeocodingPart();
    }

    @Override
    public ProfilePartReader createTimePartReader() {
        return new HdfEosTimePart();
    }

    @Override
    public ProfilePartReader createDescriptionPartReader() {
        return new HdfEosDescriptionPart();
    }

    @Override
    public ProfilePartReader createMetadataPartReader() {
        return new HdfEosMetadataPart();
    }
}

