/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.nc;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.netcdf.nc.Chunk;

public abstract class ChunkWriter {
    private final int sceneWidth;
    private final int sceneHeight;
    private final int chunkWidth;
    private final int chunkHeight;
    private final boolean yFlipped;
    private final int numChunksX;
    private final int numChunksY;
    private final Map<Point, Chunk> activeChunks;

    public ChunkWriter(int sceneWidth, int sceneHeight, int chunkWidth, int chunkHeight, boolean yFlipped) {
        this.sceneWidth = sceneWidth;
        this.sceneHeight = sceneHeight;
        this.chunkWidth = chunkWidth;
        this.chunkHeight = chunkHeight;
        this.yFlipped = yFlipped;
        this.numChunksX = (int)Math.ceil((double)sceneWidth / (double)chunkWidth);
        this.numChunksY = (int)Math.ceil((double)sceneHeight / (double)chunkHeight);
        this.activeChunks = new HashMap<Point, Chunk>();
    }

    public void write(int x, int y, int width, int height, ProductData data) throws IOException {
        if (this.yFlipped) {
            if (height != 1) {
                ProductData flippedData = ProductData.createInstance((int)data.getType(), (int)data.getNumElems());
                for (int line = 0; line < height; ++line) {
                    int flippedLine = height - 1 - line;
                    int srcPos = line * width;
                    int destPos = flippedLine * width;
                    System.arraycopy(data.getElems(), srcPos, flippedData.getElems(), destPos, width);
                }
                data = flippedData;
            }
            y = this.sceneHeight - (y + height);
        }
        Point[] chunkIndices = this.getChunkIndices(x, y, width, height);
        Rectangle dataRect = new Rectangle(x, y, width, height);
        for (Point chunkIndex : chunkIndices) {
            Rectangle chunkRect = this.getChunkRect(chunkIndex);
            if (chunkRect.equals(dataRect)) {
                this.writeChunk(chunkRect, data);
                continue;
            }
            Chunk chunk = this.activeChunks.get(chunkIndex);
            if (chunk == null) {
                chunk = new Chunk(chunkRect, data.getType());
                this.activeChunks.put(chunkIndex, chunk);
            }
            chunk.copyDataFrom(dataRect, data);
            if (!chunk.complete()) continue;
            this.writeChunk(chunkRect, chunk.getData());
            this.activeChunks.remove(chunkIndex);
        }
    }

    Point[] getChunkIndices(int x, int y, int width, int height) {
        int minTileX = this.getChunkX(x);
        int maxTileX = this.getChunkX(x + width - 1);
        int minTileY = this.getChunkY(y);
        int maxTileY = this.getChunkY(y + height - 1);
        Point[] tileIndices = new Point[(maxTileY - minTileY + 1) * (maxTileX - minTileX + 1)];
        int tileIndexOffset = 0;
        for (int ty = minTileY; ty <= maxTileY; ++ty) {
            for (int tx = minTileX; tx <= maxTileX; ++tx) {
                tileIndices[tileIndexOffset++] = new Point(tx, ty);
            }
        }
        return tileIndices;
    }

    int getChunkX(int x) {
        return x / this.chunkWidth;
    }

    int getChunkY(int y) {
        return y / this.chunkHeight;
    }

    Rectangle getChunkRect(Point chunkIndex) {
        return new Rectangle(this.sceneWidth, this.sceneHeight).intersection(new Rectangle(chunkIndex.x * this.chunkWidth, chunkIndex.y * this.chunkHeight, this.chunkWidth, this.chunkHeight));
    }

    public int getNumChunksX() {
        return this.numChunksX;
    }

    public int getNumChunksY() {
        return this.numChunksY;
    }

    public abstract void writeChunk(Rectangle var1, ProductData var2) throws IOException;
}

